/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.tasks.ResultPreviewListener;
import moa.tasks.TaskMonitor;

public class StandardTaskMonitor
implements TaskMonitor {
    protected String currentActivityDescription = "";
    protected double currentActivityFractionComplete = -1.0;
    protected volatile boolean cancelFlag = false;
    protected volatile boolean pauseFlag = false;
    protected volatile boolean isComplete = false;
    protected volatile boolean resultPreviewRequested = false;
    protected volatile Object latestResultPreview = null;
    protected volatile ResultPreviewListener resultPreviewer = null;

    @Override
    public void setCurrentActivity(String activityDescription, double fracComplete) {
        this.setCurrentActivityDescription(activityDescription);
        this.setCurrentActivityFractionComplete(fracComplete);
    }

    @Override
    public void setCurrentActivityDescription(String activity) {
        this.currentActivityDescription = activity;
    }

    @Override
    public void setCurrentActivityFractionComplete(double fracComplete) {
        this.currentActivityFractionComplete = fracComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean taskShouldAbort() {
        if (this.pauseFlag) {
            try {
                StandardTaskMonitor standardTaskMonitor = this;
                synchronized (standardTaskMonitor) {
                    while (this.pauseFlag && !this.cancelFlag) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.cancelFlag;
    }

    @Override
    public String getCurrentActivityDescription() {
        return this.currentActivityDescription;
    }

    @Override
    public double getCurrentActivityFractionComplete() {
        return this.currentActivityFractionComplete;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelFlag;
    }

    @Override
    public void requestCancel() {
        this.cancelFlag = true;
        this.requestResume();
    }

    @Override
    public void requestPause() {
        this.pauseFlag = true;
    }

    @Override
    public synchronized void requestResume() {
        this.pauseFlag = false;
        this.notify();
    }

    @Override
    public boolean isPaused() {
        return this.pauseFlag;
    }

    @Override
    public Object getLatestResultPreview() {
        return this.latestResultPreview;
    }

    @Override
    public void requestResultPreview() {
        this.resultPreviewRequested = true;
    }

    @Override
    public void requestResultPreview(ResultPreviewListener toInform) {
        this.resultPreviewer = toInform;
        this.resultPreviewRequested = true;
    }

    @Override
    public boolean resultPreviewRequested() {
        return this.resultPreviewRequested;
    }

    @Override
    public synchronized void setLatestResultPreview(Object latestPreview) {
        this.resultPreviewRequested = false;
        this.latestResultPreview = latestPreview;
        if (this.resultPreviewer != null) {
            this.resultPreviewer.latestPreviewChanged();
        }
        this.resultPreviewer = null;
    }
}

