/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.seats;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.tramoseats.base.api.seats.SeatsException;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SeatsModelSpec
implements Validatable<SeatsModelSpec> {
    private final TsData series;
    private final boolean log;
    private final boolean meanCorrection;
    private final double innovationVariance;
    private final SarimaSpec sarimaSpec;
    private static final SarimaSpec AIRLINE = SarimaSpec.airline();

    public static Builder builder() {
        return new Builder().sarimaSpec(AIRLINE).log(false).meanCorrection(false);
    }

    public SeatsModelSpec validate() throws IllegalArgumentException {
        if (this.series == null) {
            throw new SeatsException("No data");
        }
        if (this.series.length() < 3 * this.series.getAnnualFrequency()) {
            throw new SeatsException("Not enough observations");
        }
        return this;
    }

    @Generated
    SeatsModelSpec(TsData series, boolean log, boolean meanCorrection, double innovationVariance, SarimaSpec sarimaSpec) {
        this.series = series;
        this.log = log;
        this.meanCorrection = meanCorrection;
        this.innovationVariance = innovationVariance;
        this.sarimaSpec = sarimaSpec;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().series(this.series).log(this.log).meanCorrection(this.meanCorrection).innovationVariance(this.innovationVariance).sarimaSpec(this.sarimaSpec);
    }

    @Generated
    public TsData getSeries() {
        return this.series;
    }

    @Generated
    public boolean isLog() {
        return this.log;
    }

    @Generated
    public boolean isMeanCorrection() {
        return this.meanCorrection;
    }

    @Generated
    public double getInnovationVariance() {
        return this.innovationVariance;
    }

    @Generated
    public SarimaSpec getSarimaSpec() {
        return this.sarimaSpec;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsModelSpec)) {
            return false;
        }
        SeatsModelSpec other = (SeatsModelSpec)o;
        if (this.isLog() != other.isLog()) {
            return false;
        }
        if (this.isMeanCorrection() != other.isMeanCorrection()) {
            return false;
        }
        if (Double.compare(this.getInnovationVariance(), other.getInnovationVariance()) != 0) {
            return false;
        }
        TsData this$series = this.getSeries();
        TsData other$series = other.getSeries();
        if (this$series == null ? other$series != null : !this$series.equals(other$series)) {
            return false;
        }
        SarimaSpec this$sarimaSpec = this.getSarimaSpec();
        SarimaSpec other$sarimaSpec = other.getSarimaSpec();
        return !(this$sarimaSpec == null ? other$sarimaSpec != null : !this$sarimaSpec.equals(other$sarimaSpec));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLog() ? 79 : 97);
        result = result * 59 + (this.isMeanCorrection() ? 79 : 97);
        long $innovationVariance = Double.doubleToLongBits(this.getInnovationVariance());
        result = result * 59 + (int)($innovationVariance >>> 32 ^ $innovationVariance);
        TsData $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : $series.hashCode());
        SarimaSpec $sarimaSpec = this.getSarimaSpec();
        result = result * 59 + ($sarimaSpec == null ? 43 : $sarimaSpec.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsModelSpec(series=" + String.valueOf(this.getSeries()) + ", log=" + this.isLog() + ", meanCorrection=" + this.isMeanCorrection() + ", innovationVariance=" + this.getInnovationVariance() + ", sarimaSpec=" + String.valueOf(this.getSarimaSpec()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<SeatsModelSpec> {
        @Generated
        private TsData series;
        @Generated
        private boolean log;
        @Generated
        private boolean meanCorrection;
        @Generated
        private double innovationVariance;
        @Generated
        private SarimaSpec sarimaSpec;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder series(TsData series) {
            this.series = series;
            return this;
        }

        @Generated
        public @NonNull Builder log(boolean log) {
            this.log = log;
            return this;
        }

        @Generated
        public @NonNull Builder meanCorrection(boolean meanCorrection) {
            this.meanCorrection = meanCorrection;
            return this;
        }

        @Generated
        public @NonNull Builder innovationVariance(double innovationVariance) {
            this.innovationVariance = innovationVariance;
            return this;
        }

        @Generated
        public @NonNull Builder sarimaSpec(SarimaSpec sarimaSpec) {
            this.sarimaSpec = sarimaSpec;
            return this;
        }

        @Generated
        public @NonNull SeatsModelSpec buildWithoutValidation() {
            return new SeatsModelSpec(this.series, this.log, this.meanCorrection, this.innovationVariance, this.sarimaSpec);
        }

        @Generated
        public @NonNull String toString() {
            return "SeatsModelSpec.Builder(series=" + String.valueOf(this.series) + ", log=" + this.log + ", meanCorrection=" + this.meanCorrection + ", innovationVariance=" + this.innovationVariance + ", sarimaSpec=" + String.valueOf(this.sarimaSpec) + ")";
        }
    }
}

