/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.protobuf.toolkit;

import java.util.Map;
import jdplus.toolkit.base.api.timeseries.DynamicTsDataSupplier;
import jdplus.toolkit.base.api.timeseries.StaticTsDataSupplier;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarManager;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.TsDataSuppliers;
import jdplus.toolkit.base.api.util.NameManager;
import jdplus.toolkit.base.protobuf.toolkit.CalendarProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;

public final class ModellingContextProto {
    public static final String R = "r";
    public static final String RPREFIX = "r@";

    public static ToolkitProtos.TsDataSuppliers.Item convert(String name, TsDataSupplier supplier) {
        ToolkitProtos.TsDataSuppliers.Item.Builder builder = ToolkitProtos.TsDataSuppliers.Item.newBuilder();
        builder.setName(name);
        if (supplier instanceof StaticTsDataSupplier) {
            StaticTsDataSupplier s = (StaticTsDataSupplier)supplier;
            builder.setData(ToolkitProtosUtility.convert(s.getData()));
        } else if (supplier instanceof DynamicTsDataSupplier) {
            DynamicTsDataSupplier s = (DynamicTsDataSupplier)supplier;
            ToolkitProtos.DynamicTsData.Builder dbuilder = ToolkitProtos.DynamicTsData.newBuilder();
            dbuilder.setMoniker(ToolkitProtosUtility.convert(s.getMoniker()));
            dbuilder.setCurrent(ToolkitProtosUtility.convert(s.get()));
            builder.setDynamicData(dbuilder.build());
        }
        return builder.build();
    }

    public static ToolkitProtos.TsDataSuppliers convert(TsDataSuppliers suppliers) {
        ToolkitProtos.TsDataSuppliers.Builder builder = ToolkitProtos.TsDataSuppliers.newBuilder();
        for (String name : suppliers.getNames()) {
            builder.addItems(ModellingContextProto.convert(name, (TsDataSupplier)suppliers.get(name)));
        }
        return builder.build();
    }

    public static TsDataSupplier convert(ToolkitProtos.TsDataSuppliers.Item supplier) {
        if (supplier.hasData()) {
            return new StaticTsDataSupplier(ToolkitProtosUtility.convert(supplier.getData()));
        }
        if (supplier.hasDynamicData()) {
            return new DynamicTsDataSupplier(ToolkitProtosUtility.convert(supplier.getDynamicData().getMoniker()), ToolkitProtosUtility.convert(supplier.getDynamicData().getCurrent()));
        }
        return null;
    }

    public static TsDataSuppliers convert(ToolkitProtos.TsDataSuppliers suppliers) {
        TsDataSuppliers s = new TsDataSuppliers();
        for (ToolkitProtos.TsDataSuppliers.Item item : suppliers.getItemsList()) {
            s.set(item.getName(), (Object)ModellingContextProto.convert(item));
        }
        return s;
    }

    public static ModellingContext convert(ToolkitProtos.ModellingContext context) {
        ModellingContext rslt = new ModellingContext();
        Map<String, ToolkitProtos.CalendarDefinition> cmgr = context.getCalendarsMap();
        for (Map.Entry<String, ToolkitProtos.CalendarDefinition> entry : cmgr.entrySet()) {
            rslt.getCalendars().set(entry.getKey(), (Object)CalendarProtosUtility.convert(entry.getValue()));
        }
        Map<String, ToolkitProtos.TsDataSuppliers> smap = context.getVariablesMap();
        for (Map.Entry<String, ToolkitProtos.TsDataSuppliers> entry : smap.entrySet()) {
            rslt.getTsVariableManagers().set(entry.getKey(), (Object)ModellingContextProto.convert(entry.getValue()));
        }
        return rslt;
    }

    public static ToolkitProtos.Calendars convert(CalendarManager cmgr) {
        ToolkitProtos.Calendars.Builder builder = ToolkitProtos.Calendars.newBuilder();
        for (String key : cmgr.getNames()) {
            CalendarDefinition cd;
            ToolkitProtos.CalendarDefinition cdef;
            if (key.equals("Default") || (cdef = CalendarProtosUtility.convert(cd = (CalendarDefinition)cmgr.get(key))) == null) continue;
            builder.putCalendars(key, cdef);
        }
        return builder.build();
    }

    public static CalendarManager convert(ToolkitProtos.Calendars cal) {
        CalendarManager rslt = new CalendarManager();
        Map<String, ToolkitProtos.CalendarDefinition> cmgr = cal.getCalendarsMap();
        for (Map.Entry<String, ToolkitProtos.CalendarDefinition> entry : cmgr.entrySet()) {
            rslt.set(entry.getKey(), (Object)CalendarProtosUtility.convert(entry.getValue()));
        }
        return rslt;
    }

    public static ToolkitProtos.ModellingContext convert(ModellingContext context) {
        ToolkitProtos.ModellingContext.Builder builder = ToolkitProtos.ModellingContext.newBuilder();
        CalendarManager cmgr = context.getCalendars();
        for (String key : cmgr.getNames()) {
            CalendarDefinition cd;
            ToolkitProtos.CalendarDefinition cdef;
            if (key.equals("Default") || (cdef = CalendarProtosUtility.convert(cd = (CalendarDefinition)cmgr.get(key))) == null) continue;
            builder.putCalendars(key, cdef);
        }
        NameManager tmgr = context.getTsVariableManagers();
        for (String key : tmgr.getNames()) {
            TsDataSuppliers cur = (TsDataSuppliers)tmgr.get(key);
            ToolkitProtos.TsDataSuppliers s = ModellingContextProto.convert(cur);
            if (s == null) continue;
            builder.putVariables(key, s);
        }
        return builder.build();
    }

    @Generated
    private ModellingContextProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

