/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.InverseChanneling;
import choco.cp.solver.constraints.integer.InverseChannelingWithinRange;
import choco.cp.solver.constraints.integer.channeling.BooleanChanneling;
import choco.cp.solver.constraints.integer.channeling.DomainChanneling;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class ChannelingManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Object[]) {
            Object[] params = (Object[])parameters;
            ConstraintType type = (ConstraintType)((Object)params[0]);
            switch (type) {
                case CHANNELING: {
                    IntDomainVar intv;
                    IntDomainVar boolv;
                    IntDomainVar yij = solver.getVar(variables[0]);
                    IntDomainVar xi = solver.getVar(variables[1]);
                    int j = ((IntegerConstantVariable)variables[2]).getValue();
                    if (yij.getInf() >= 0 && yij.getSup() <= 1) {
                        boolv = yij;
                        intv = xi;
                    } else {
                        boolv = xi;
                        intv = yij;
                    }
                    if (boolv.getInf() >= 0 && boolv.getSup() <= 1) {
                        return new BooleanChanneling(boolv, intv, j);
                    }
                    throw new SolverException(yij + " should be a boolean variable and " + j + " should belongs to the domain of " + xi);
                }
                case INVERSECHANNELING: {
                    IntDomainVar[] var = solver.getVar(variables);
                    return new InverseChanneling(var, var.length / 2);
                }
                case INVERSECHANNELINGWITHINRANGE: {
                    int nbx = (Integer)params[1];
                    IntDomainVar[] var = solver.getVar(variables);
                    return new InverseChannelingWithinRange(var, nbx);
                }
                case DOMAIN_CHANNELING: {
                    return new DomainChanneling(VariableUtils.getIntVar(solver, variables, 0, variables.length - 1), solver.getVar(variables[variables.length - 1]), solver.getEnvironment());
                }
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }
}

