% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indiedown.R
\name{indiedown_glue}
\alias{indiedown_glue}
\title{Glue LaTeX Code for Use in R Markdown}
\usage{
indiedown_glue(x, .open = "<<", .close = ">>")
}
\arguments{
\item{x}{Character, often as a raw string (\code{r"()"})}

\item{.open, .close}{The opening and closing delimiter.}
}
\value{
Object of class \code{"knit_asis"} (so that knitr will treat it as is). Usually LaTeX code.
}
\description{
Use the function to wrap literal LaTeX code in R. Use a raw string input
(\code{r"()"}) to automatically escape quotes and backslashes, as they are common
in LaTeX. Expressions enclosed by \verb{<<} and \verb{>>} will be evaluated as R code.
}
\details{
\code{indiedown_glue()} uses a different default than the underlying
\code{glue::glue()} (\verb{<<} and \verb{>>}), because braces are so common in LaTeX.
Doubling the full delimiter (\verb{<<<<} and \verb{>>>>}) escapes it.
}
\examples{
x <- "something"
indiedown_glue(r"(\LaTeX\ code with <<x>> substituted )")

}
