/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveUseless
extends Filter
implements UnsupervisedFilter,
OptionHandler,
WeightedInstancesHandler,
WeightedAttributesHandler {
    static final long serialVersionUID = -8659417851407640038L;
    protected Remove m_removeFilter = null;
    protected double m_maxVariancePercentage = 99.0;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_removeFilter = null;
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_removeFilter != null) {
            this.m_removeFilter.input(instance);
            Instance processed = this.m_removeFilter.output();
            this.copyValues(processed, false, instance.dataset(), this.outputFormatPeek());
            this.push(processed, false);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_removeFilter == null) {
            Instance processed;
            Instances toFilter = this.getInputFormat();
            int[] attsToDelete = new int[toFilter.numAttributes()];
            int numToDelete = 0;
            for (int i = 0; i < toFilter.numAttributes(); ++i) {
                double variancePercent;
                if (i == toFilter.classIndex()) continue;
                AttributeStats stats = toFilter.attributeStats(i);
                if (stats.missingCount == toFilter.numInstances()) {
                    attsToDelete[numToDelete++] = i;
                    continue;
                }
                if (stats.distinctCount < 2) {
                    attsToDelete[numToDelete++] = i;
                    continue;
                }
                if (!toFilter.attribute(i).isNominal() || !((variancePercent = (double)stats.distinctCount / (double)(stats.totalCount - stats.missingCount) * 100.0) > this.m_maxVariancePercentage)) continue;
                attsToDelete[numToDelete++] = i;
            }
            int[] finalAttsToDelete = new int[numToDelete];
            System.arraycopy(attsToDelete, 0, finalAttsToDelete, 0, numToDelete);
            this.m_removeFilter = new Remove();
            this.m_removeFilter.setAttributeIndicesArray(finalAttsToDelete);
            this.m_removeFilter.setInvertSelection(false);
            this.m_removeFilter.setInputFormat(toFilter);
            for (int i = 0; i < toFilter.numInstances(); ++i) {
                this.m_removeFilter.input(toFilter.instance(i));
            }
            this.m_removeFilter.batchFinished();
            Instances outputDataset = this.m_removeFilter.getOutputFormat();
            outputDataset.setRelationName(toFilter.relationName());
            this.setOutputFormat(outputDataset);
            while ((processed = this.m_removeFilter.output()) != null) {
                processed.setDataset(outputDataset);
                this.push(processed, false);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tMaximum variance percentage allowed (default 99). Specifically, if\t(number_of_distinct_values / total_number_of_values * 100)\tis greater than this value, then the attribute will be removed.", "M", 1, "-M <max variance %>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String mString = Utils.getOption('M', options);
        if (mString.length() != 0) {
            this.setMaximumVariancePercentageAllowed((int)Double.valueOf(mString).doubleValue());
        } else {
            this.setMaximumVariancePercentageAllowed(99.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-M");
        options.add("" + this.getMaximumVariancePercentageAllowed());
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "This filter removes attributes that do not vary at all or that vary too much. All constant attributes are deleted automatically, along with any that exceed the maximum percentage of variance parameter. The maximum variance test is only applied to nominal attributes.";
    }

    public String maximumVariancePercentageAllowedTipText() {
        return "Set the threshold for the highest variance allowed before a nominal attribute will be deleted. Specifically, if (number_of_distinct_values / total_number_of_values * 100) is greater than this value, then the attribute will be removed.";
    }

    public void setMaximumVariancePercentageAllowed(double maxVariance) {
        this.m_maxVariancePercentage = maxVariance;
    }

    public double getMaximumVariancePercentageAllowed() {
        return this.m_maxVariancePercentage;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14508 $");
    }

    public static void main(String[] argv) {
        RemoveUseless.runFilter(new RemoveUseless(), argv);
    }
}

