/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.denton.DentonMethod;
import ec.benchmarking.simplets.AbstractTsBenchmarking;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TsDenton2
extends AbstractTsBenchmarking {
    private boolean mul = true;
    private boolean modified = true;
    private int diff = 1;
    private TsFrequency defFreq = TsFrequency.Quarterly;

    @Override
    protected TsData benchmark(TsData series, TsData aggregationConstaints) {
        int qfreq;
        if (aggregationConstaints == null) {
            return null;
        }
        DentonMethod denton = new DentonMethod();
        denton.setAggregationType(this.getAggregationType());
        denton.setDifferencingOrder(this.diff);
        denton.setMultiplicative(this.mul);
        denton.setModifiedDenton(this.modified);
        int yfreq = aggregationConstaints.getFrequency().intValue();
        int n = qfreq = series != null ? series.getFrequency().intValue() : this.defFreq.intValue();
        if (qfreq % yfreq != 0) {
            return null;
        }
        denton.setConversionFactor(qfreq / yfreq);
        if (series != null) {
            TsPeriodSelector qsel = new TsPeriodSelector();
            qsel.between(series.getStart().firstday(), series.getLastPeriod().lastday());
            aggregationConstaints = aggregationConstaints.select(qsel);
            TsPeriod q0 = series.getStart();
            TsPeriod yq0 = new TsPeriod(q0.getFrequency());
            yq0.set(aggregationConstaints.getStart().firstday());
            denton.setOffset(yq0.minus(q0));
            double[] r = denton.process(series, aggregationConstaints);
            return new TsData(series.getStart(), r, false);
        }
        TsPeriod qstart = aggregationConstaints.getStart().firstPeriod(this.defFreq);
        double[] r = denton.process(aggregationConstaints);
        return new TsData(qstart, r, false);
    }

    public boolean isMultiplicative() {
        return this.mul;
    }

    public void setMultiplicative(boolean value) {
        this.mul = value;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public int getDifferencingOrder() {
        return this.diff;
    }

    public void setDifferencingOrder(int diff) {
        this.diff = diff;
    }

    public TsFrequency getDefaultFrequency() {
        return this.defFreq;
    }

    public void setDefaultFrequency(TsFrequency defFreq) {
        this.defFreq = defFreq;
    }
}

