/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.CompoundFunction;
import dr.math.Integral;
import dr.math.LogTricks;
import dr.math.UnivariateFunction;
import dr.math.distributions.NormalDistribution;

public class RiemannApproximation
implements Integral {
    private int sampleSize;
    private final variant mode;

    public RiemannApproximation(int n, variant variant2) {
        this.mode = variant2;
        this.sampleSize = n;
    }

    public RiemannApproximation(int n) {
        this(n, variant.UPPER);
    }

    @Override
    public double integrate(UnivariateFunction univariateFunction, double d, double d2) {
        double d3 = 0.0;
        double d4 = d;
        double d5 = (d2 - d) / (double)this.sampleSize;
        switch (this.mode) {
            case UPPER: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 += univariateFunction.evaluate(d4 += d5);
                }
                break;
            }
            case LOWER: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 += univariateFunction.evaluate(d4);
                    d4 += d5;
                }
                break;
            }
            case MIDPOINT: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 += univariateFunction.evaluate(d4 + d5 / 2.0);
                    d4 += d5;
                }
                break;
            }
            case TRAPEZOID: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 += (univariateFunction.evaluate(d4) + univariateFunction.evaluate(d4 + d5)) / 2.0;
                    d4 += d5;
                }
                break;
            }
        }
        return d3 *= (d2 - d) / (double)this.sampleSize;
    }

    public double logIntegrate(UnivariateFunction univariateFunction, double d, double d2) {
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = d;
        double d5 = (d2 - d) / (double)this.sampleSize;
        switch (this.mode) {
            case UPPER: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 = LogTricks.logSum(d3, Math.log(univariateFunction.evaluate(d4 += d5)));
                }
                break;
            }
            case LOWER: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 = LogTricks.logSum(d3, Math.log(univariateFunction.evaluate(d4)));
                    d4 += d5;
                }
                break;
            }
            case MIDPOINT: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 = LogTricks.logSum(d3, Math.log(univariateFunction.evaluate(d4 + d5 / 2.0)));
                    d4 += d5;
                }
                break;
            }
            case TRAPEZOID: {
                for (int i = 1; i <= this.sampleSize; ++i) {
                    d3 = LogTricks.logSum(d3, Math.log((univariateFunction.evaluate(d4) + univariateFunction.evaluate(d4 + d5)) / 2.0));
                    d4 += d5;
                }
                break;
            }
        }
        return d3 += Math.log((d2 - d) / (double)this.sampleSize);
    }

    public variant getMode() {
        return this.mode;
    }

    public static void main(String[] stringArray) {
        UnivariateFunction univariateFunction = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        UnivariateFunction univariateFunction2 = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        UnivariateFunction univariateFunction3 = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        double d = 1.0;
        CompoundFunction compoundFunction = new CompoundFunction(new UnivariateFunction[]{univariateFunction, univariateFunction2, univariateFunction3}, d);
        System.out.println("Riemann approximation to the integral of a three normal distribution:");
        RiemannApproximation riemannApproximation = new RiemannApproximation(100000);
        System.out.println("integral(N(0.0, 1.0))=" + riemannApproximation.integrate(univariateFunction, -4.0, 4.0));
        System.out.println("integral(N(1.0, 2.0))=" + riemannApproximation.integrate(univariateFunction2, -8.0, 8.0));
        System.out.println("integral(N(2.0, 3.0))=" + riemannApproximation.integrate(univariateFunction3, -16.0, 16.0));
        double d2 = riemannApproximation.integrate(compoundFunction, -16.0, 16.0);
        System.out.println("Riemann approximation to the integral of the compound of three normal distribution:");
        System.out.println("integral(N(0.0, 1.0)*N(1.0, 2.0)*N(2.0, 3.0))=" + d2);
        System.out.println("Estimate normalizing constant is " + 1.0 / d2);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public static enum variant {
        UPPER,
        LOWER,
        MIDPOINT,
        TRAPEZOID;

    }
}

