/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.IModelEstimator;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;

class FinalEstimator
implements IModelEstimator {
    public static final String ESTIMATION = "full estimation";
    public static final String FAILED = "estimation faied";
    public static final String SPEC_CHANGED = "arima spec changed";
    private static final int MAXD = 2;
    private static final int MAXBD = 1;
    private final double cancel;
    private final double tsig;
    private final double ur;
    private final double eps;
    private final int pass;
    private final boolean ami;
    private final boolean outliers;
    private int nnsig;

    public static Builder builder() {
        return new Builder();
    }

    private FinalEstimator(Builder builder) {
        this.cancel = builder.cancel;
        this.eps = builder.precision;
        this.tsig = builder.significanceThreshold;
        this.ur = builder.unitRootThreshold;
        this.pass = builder.pass;
        this.ami = builder.ami;
        this.outliers = builder.outliers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean estimate(RegSarimaModelling context) {
        int niter = 0;
        ProcessingLog log = context.getLog();
        log.push(ESTIMATION);
        try {
            do {
                IArimaMapping mapping = context.getDescription().mapping();
                RegSarimaComputer processor = RegSarimaComputer.builder().minimizer((SsqFunctionMinimizer.Builder)LevenbergMarquardtMinimizer.builder()).precision(this.eps).computeExactFinalDerivatives(true).build();
                context.estimate((IRegArimaComputer)processor);
                int ndim = mapping.getDim();
                if (ndim == 0) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.ami) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.checkUnitRoots(context)) continue;
                this.nnsig = 0;
                this.nnsig = !this.checkCommonRoots(context) ? 2 : this.test(context);
                if (this.nnsig == 0) {
                    boolean bl = true;
                    return bl;
                }
                if (this.nnsig == 1 || !this.outliers || this.pass > 1) continue;
                boolean bl = false;
                return bl;
            } while (niter++ < 5);
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException err) {
            log.remark(FAILED);
            boolean bl = false;
            return bl;
        }
        finally {
            log.pop();
        }
    }

    public int getChangedParametersCount() {
        return this.nnsig;
    }

    private int test(RegSarimaModelling context) {
        int nsig;
        double t;
        double s;
        double v;
        double cval = this.tsig;
        int nz = context.getDescription().getEstimationDomain().getLength();
        double cmin = nz <= 150 ? 0.15 : 0.1;
        double cmod = 0.95;
        SarimaModel m = context.getDescription().arima();
        SarimaOrders spec = m.orders();
        DoubleSeq pm = m.parameters();
        int icpr = 0;
        int icps = 0;
        int icqr = 0;
        int icqs = 0;
        double bmin = 99999.0;
        int k = -1;
        double tmin = cval;
        DataBlock diag = context.getEstimation().getMax().asymptoticCovariance().diagonal();
        k += spec.getP();
        if (spec.getP() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin) {
                icpr = 1;
                bmin = t;
            }
        }
        k += spec.getBp();
        if (spec.getBp() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                bmin = t;
                icps = 1;
                icpr = 0;
            }
        }
        k += spec.getQ();
        if (spec.getQ() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                bmin = t;
                icqr = 1;
                icpr = 0;
                icps = 0;
            }
        }
        k += spec.getBq();
        if (spec.getBq() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && v < cmin && bmin > t) {
                icqs = 1;
                icpr = 0;
                icps = 0;
                icqr = 0;
            }
        }
        if ((nsig = icpr + icps + icqr + icqs) == 0) {
            return 0;
        }
        SarimaOrders nspec = spec.clone();
        if (icpr > 0) {
            nspec.setP(nspec.getP() - 1);
        }
        if (icps > 0) {
            nspec.setBp(nspec.getBp() - 1);
        }
        if (icqr > 0) {
            nspec.setQ(nspec.getQ() - 1);
        }
        if (icqs > 0) {
            nspec.setBq(nspec.getBq() - 1);
        }
        context.getLog().info(SPEC_CHANGED, (Object)nspec);
        context.setSpecification(nspec);
        return nsig;
    }

    private boolean checkCommonRoots(RegSarimaModelling context) {
        SarimaModel arima = context.getDescription().arima();
        SarimaOrders spec = arima.orders();
        boolean changed = false;
        if (spec.getP() != 0 && spec.getQ() != 0) {
            int i;
            Polynomial p = arima.getRegularAR();
            Polynomial q = arima.getRegularMA();
            Complex[] pr = p.roots();
            Complex[] qr = q.roots();
            for (i = 0; i < pr.length; ++i) {
                pr[i] = pr[i].inv();
            }
            for (i = 0; i < qr.length; ++i) {
                qr[i] = qr[i].inv();
            }
        }
        if (spec.getBp() == 1 && spec.getBq() == 1 && Math.abs(arima.bphi(1) - arima.btheta(1)) < this.cancel) {
            spec.setBp(0);
            spec.setBq(0);
            changed = true;
        }
        if (changed) {
            context.setSpecification(spec);
            return false;
        }
        return true;
    }

    private boolean checkUnitRoots(RegSarimaModelling context) {
        SarimaModel m = context.getDescription().arima();
        SarimaOrders nspec = m.orders();
        boolean ok = true;
        if (nspec.getP() > 0 && nspec.getD() < 2 && 0 != this.searchur(m.getRegularAR().mirror().roots())) {
            nspec.setP(nspec.getP() - 1);
            nspec.setD(nspec.getD() + 1);
            ok = false;
        }
        if (nspec.getBp() > 0 && nspec.getBd() < 1 && 0 != this.searchur(m.getSeasonalAR().mirror().roots())) {
            nspec.setBp(nspec.getBp() - 1);
            nspec.setBd(nspec.getBd() + 1);
            ok = false;
        }
        if (ok) {
            return true;
        }
        context.setSpecification(nspec);
        return false;
    }

    private int searchur(Complex[] r) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (!(vcur > this.ur) || !(cdim <= 0.05) || !(r[i].getRe() > 0.0)) continue;
            ++n;
        }
        return n;
    }

    public static class Builder {
        private double cancel = 0.044;
        private double significanceThreshold = 1.0;
        private double unitRootThreshold = 0.96;
        private double precision = 1.0E-4;
        private int pass = 0;
        private boolean ami = false;
        private boolean outliers = false;

        public FinalEstimator build() {
            return new FinalEstimator(this);
        }

        public Builder precision(double precision) {
            this.precision = precision;
            return this;
        }

        public Builder cancel(double cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder unitRootThreshold(double ur) {
            this.unitRootThreshold = ur;
            return this;
        }

        public Builder pass(int pass) {
            this.pass = pass;
            return this;
        }

        public Builder ami(boolean ami) {
            this.ami = ami;
            return this;
        }

        public Builder outliers(boolean outliers) {
            this.outliers = outliers;
            return this;
        }
    }
}

