/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.tramoseats.base.core.seats.SeatsTests;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnostics;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnosticsConfiguration;

public class SeatsDiagnosticsFactory<R>
implements SaDiagnosticsFactory<SeatsDiagnosticsConfiguration, R> {
    public static final String SEAS_VAR = "seas variance";
    public static final String IRR_VAR = "irregular variance";
    public static final String SEAS_I_CORR = "seas/irr cross-correlation";
    public static final String NOTSAME = "Non decomposable model. Changed by Seats";
    public static final String CUTOFF = "Parameters cut off by Seats";
    public static final String NAME = "Seats";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("seas variance", "irregular variance", "seas/irr cross-correlation"));
    private final SeatsDiagnosticsConfiguration config;
    private final Function<R, SeatsTests> extractor;

    public SeatsDiagnosticsFactory(SeatsDiagnosticsConfiguration config, Function<R, SeatsTests> extractor) {
        this.config = config;
        this.extractor = extractor;
    }

    public SeatsDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public SeatsDiagnosticsFactory<R> with(SeatsDiagnosticsConfiguration config) {
        return new SeatsDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return SeatsDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Decomposition;
    }

    public int getOrder() {
        return 100;
    }
}

