/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ucarima.IRootSelector;
import jdplus.toolkit.base.core.ucarima.ModelDecomposer;
import jdplus.toolkit.base.core.ucarima.SeasonalSelector;
import jdplus.toolkit.base.core.ucarima.TrendCycleSelector;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.core.seats.IModelDecomposer;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultModelDecomposer
implements IModelDecomposer {
    private final DecompositionSpec spec;

    @Override
    public UcarimaModel decompose(SarimaModel arima) {
        try {
            int period = arima.getPeriod();
            SarimaOrders orders = arima.orders();
            TrendCycleSelector tsel = new TrendCycleSelector(this.spec.getTrendBoundary());
            tsel.setDefaultLowFreqThreshold(period);
            SeasonalSelector ssel = new SeasonalSelector(period, this.spec.getSeasTolerance());
            if (orders.getBd() > 0 || orders.getBp() > 0) {
                ssel.setK(this.spec.getSeasBoundary());
            } else {
                ssel.setK(this.spec.getSeasBoundaryAtPi());
            }
            ModelDecomposer decomposer = new ModelDecomposer();
            decomposer.add((IRootSelector)tsel);
            decomposer.add((IRootSelector)ssel);
            UcarimaModel ucm = decomposer.decompose((IArimaModel)arima);
            return ucm.setVarianceMax(-1, this.spec.getApproximationMode() == DecompositionSpec.ModelApproximationMode.Noisy);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Generated
    public DefaultModelDecomposer(DecompositionSpec spec) {
        this.spec = spec;
    }

    @Generated
    public DecompositionSpec getSpec() {
        return this.spec;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultModelDecomposer)) {
            return false;
        }
        DefaultModelDecomposer other = (DefaultModelDecomposer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DecompositionSpec this$spec = this.getSpec();
        DecompositionSpec other$spec = other.getSpec();
        return !(this$spec == null ? other$spec != null : !this$spec.equals(other$spec));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DefaultModelDecomposer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DecompositionSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "DefaultModelDecomposer(spec=" + String.valueOf(this.getSpec()) + ")";
    }
}

