/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.r;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.processing.DefaultProcessingLog;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.api.seats.SeatsModelSpec;
import jdplus.tramoseats.base.core.seats.DefaultModelDecomposer;
import jdplus.tramoseats.base.core.seats.SeatsKernel;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.seats.SeatsToolkit;
import lombok.Generated;

public final class Seats {
    private static final String[] CMPS = new String[]{"trend", "seasonal", "transitory", "irregular"};

    public static UcarimaModel decompose(SarimaModel arima, double eps, double rmod, double smod, double smodpi, String approximation) {
        DecompositionSpec spec = (DecompositionSpec)DecompositionSpec.builder().approximationMode(DecompositionSpec.ModelApproximationMode.valueOf((String)approximation)).seasTolerance(eps).trendBoundary(rmod).seasBoundary(smod).seasBoundaryAtPi(smodpi).build();
        return new DefaultModelDecomposer(spec).decompose(arima);
    }

    public static SeatsResults process(TsData data, boolean log, int[] order, int[] seasonal, boolean mean, int nb, int nf) {
        SarimaSpec arima = (SarimaSpec)SarimaSpec.builder().p(order[0]).d(order[1]).q(order[2]).bp(seasonal == null ? 0 : seasonal[0]).bd(seasonal == null ? 0 : seasonal[1]).bq(seasonal == null ? 0 : seasonal[2]).build();
        SeatsModelSpec model = (SeatsModelSpec)SeatsModelSpec.builder().series(data).sarimaSpec(arima).log(log).meanCorrection(mean).build();
        DecompositionSpec dspec = (DecompositionSpec)DecompositionSpec.builder().forecastCount(nf).backcastCount(nb).build();
        SeatsToolkit toolkit = SeatsToolkit.of((DecompositionSpec)dspec);
        SeatsKernel kernel = new SeatsKernel(toolkit);
        DefaultProcessingLog plog = new DefaultProcessingLog();
        return kernel.process(model, (ProcessingLog)plog);
    }

    @Generated
    private Seats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

