/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CoherenceDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<CoherenceDiagnosticsConfiguration> DEFAULT = new AtomicReference<CoherenceDiagnosticsConfiguration>(CoherenceDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    private final boolean active;
    public static final double TOL = 0.001;
    public static final double ERR = 0.5;
    public static final double SEV = 0.1;
    public static final double BAD = 0.05;
    public static final double UNC = 0.01;
    public static final int SHORT = 7;
    private final double tolerance;
    private final double severeThreshold;
    private final double badThreshold;
    private final double uncertainThreshold;
    private final int shortSeriesLimit;

    public static void setDefault(CoherenceDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static CoherenceDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().active(true).tolerance(0.001).severeThreshold(0.1).badThreshold(0.05).uncertainThreshold(0.01).shortSeriesLimit(7);
    }

    public void check() {
        if (this.severeThreshold < this.badThreshold || this.badThreshold < this.uncertainThreshold || this.uncertainThreshold < 0.0) {
            throw new IllegalArgumentException("Invalid settings in Annual totals diagnostics");
        }
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    CoherenceDiagnosticsConfiguration(boolean active, double tolerance, double severeThreshold, double badThreshold, double uncertainThreshold, int shortSeriesLimit) {
        this.active = active;
        this.tolerance = tolerance;
        this.severeThreshold = severeThreshold;
        this.badThreshold = badThreshold;
        this.uncertainThreshold = uncertainThreshold;
        this.shortSeriesLimit = shortSeriesLimit;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).tolerance(this.tolerance).severeThreshold(this.severeThreshold).badThreshold(this.badThreshold).uncertainThreshold(this.uncertainThreshold).shortSeriesLimit(this.shortSeriesLimit);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getTolerance() {
        return this.tolerance;
    }

    @Generated
    public double getSevereThreshold() {
        return this.severeThreshold;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public double getUncertainThreshold() {
        return this.uncertainThreshold;
    }

    @Generated
    public int getShortSeriesLimit() {
        return this.shortSeriesLimit;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoherenceDiagnosticsConfiguration)) {
            return false;
        }
        CoherenceDiagnosticsConfiguration other = (CoherenceDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getTolerance(), other.getTolerance()) != 0) {
            return false;
        }
        if (Double.compare(this.getSevereThreshold(), other.getSevereThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getUncertainThreshold(), other.getUncertainThreshold()) != 0) {
            return false;
        }
        return this.getShortSeriesLimit() == other.getShortSeriesLimit();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $tolerance = Double.doubleToLongBits(this.getTolerance());
        result = result * 59 + (int)($tolerance >>> 32 ^ $tolerance);
        long $severeThreshold = Double.doubleToLongBits(this.getSevereThreshold());
        result = result * 59 + (int)($severeThreshold >>> 32 ^ $severeThreshold);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        long $uncertainThreshold = Double.doubleToLongBits(this.getUncertainThreshold());
        result = result * 59 + (int)($uncertainThreshold >>> 32 ^ $uncertainThreshold);
        result = result * 59 + this.getShortSeriesLimit();
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "CoherenceDiagnosticsConfiguration(active=" + this.isActive() + ", tolerance=" + this.getTolerance() + ", severeThreshold=" + this.getSevereThreshold() + ", badThreshold=" + this.getBadThreshold() + ", uncertainThreshold=" + this.getUncertainThreshold() + ", shortSeriesLimit=" + this.getShortSeriesLimit() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double tolerance;
        @Generated
        private double severeThreshold;
        @Generated
        private double badThreshold;
        @Generated
        private double uncertainThreshold;
        @Generated
        private int shortSeriesLimit;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            return this;
        }

        @Generated
        public @NonNull Builder severeThreshold(double severeThreshold) {
            this.severeThreshold = severeThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThreshold(double uncertainThreshold) {
            this.uncertainThreshold = uncertainThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder shortSeriesLimit(int shortSeriesLimit) {
            this.shortSeriesLimit = shortSeriesLimit;
            return this;
        }

        @Generated
        public @NonNull CoherenceDiagnosticsConfiguration build() {
            return new CoherenceDiagnosticsConfiguration(this.active, this.tolerance, this.severeThreshold, this.badThreshold, this.uncertainThreshold, this.shortSeriesLimit);
        }

        @Generated
        public @NonNull String toString() {
            return "CoherenceDiagnosticsConfiguration.Builder(active=" + this.active + ", tolerance=" + this.tolerance + ", severeThreshold=" + this.severeThreshold + ", badThreshold=" + this.badThreshold + ", uncertainThreshold=" + this.uncertainThreshold + ", shortSeriesLimit=" + this.shortSeriesLimit + ")";
        }
    }
}

