/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.ssf.dk.SsfFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfBuilder;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunction;

public class SsfFunction<S, F extends ISsf>
implements LikelihoodFunction<DiffuseConcentratedLikelihood> {
    private final IParametricMapping<S> mapping;
    private final ISsfBuilder<S, F> builder;
    private final ISsfData data;
    private final boolean missing;
    private final Matrix X;
    private final int diffuseElements;
    private final boolean ml;
    private final boolean log;
    private final boolean fast;
    private final boolean sqr;
    private final boolean mt;
    private final boolean sym;
    private final boolean scaling;

    public static <S, F extends ISsf> Builder builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
        return new Builder<S, F>(data, mapping, builder);
    }

    private SsfFunction(ISsfData data, Matrix X, int diffuseX, IParametricMapping<S> mapper, ISsfBuilder<S, F> builder, boolean ml, boolean log, boolean fast, boolean sqr, boolean mt, boolean sym, boolean scaling) {
        this.data = data;
        this.mapping = mapper;
        this.builder = builder;
        this.X = X;
        this.diffuseElements = diffuseX;
        this.missing = data.hasMissingValues();
        this.ml = ml;
        this.sqr = sqr;
        this.fast = fast;
        this.log = log;
        this.mt = mt;
        this.sym = sym;
        this.scaling = scaling;
    }

    public IParametricMapping<S> getMapping() {
        return this.mapping;
    }

    public boolean isMaximumLikelihood() {
        return this.ml;
    }

    public boolean isLog() {
        return this.log;
    }

    public boolean isFast() {
        return this.fast;
    }

    public boolean isSqrtInitialization() {
        return this.sqr;
    }

    public boolean isScalingFactor() {
        return this.scaling;
    }

    @Override
    public SsfFunctionPoint<S, F> evaluate(DoubleSeq parameters) {
        return new SsfFunctionPoint(this, parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public SsfFunctionPoint<S, F> ssqEvaluate(DoubleSeq parameters) {
        return new SsfFunctionPoint(this, parameters);
    }

    public ISsfBuilder<S, F> getBuilder() {
        return this.builder;
    }

    public ISsfData getData() {
        return this.data;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public Matrix getX() {
        return this.X;
    }

    public int getDiffuseElements() {
        return this.diffuseElements;
    }

    public boolean isMl() {
        return this.ml;
    }

    public boolean isMultiThreaded() {
        return this.mt;
    }

    public boolean isSymmetric() {
        return this.sym;
    }

    public static class Builder<S, F extends ISsf> {
        private final IParametricMapping<S> mapping;
        private final ISsfBuilder<S, F> builder;
        private final ISsfData data;
        private Matrix X;
        private int diffuseElements;
        private boolean ml = true;
        private boolean log = false;
        private boolean fast = false;
        private boolean sqr = true;
        private boolean mt = false;
        private boolean sym = false;
        private boolean scalingFactor = true;

        private Builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
            this.data = data;
            this.builder = builder;
            this.mapping = mapping;
        }

        public Builder regression(Matrix X, int diffuseX) {
            this.X = X;
            this.diffuseElements = diffuseX;
            return this;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useLog(boolean log) {
            this.log = log;
            return this;
        }

        public Builder useFastAlgorithm(boolean fast) {
            this.fast = fast;
            return this;
        }

        public Builder useSqrtInitialization(boolean sqr) {
            this.sqr = sqr;
            return this;
        }

        public Builder useSymmetricNumericalDerivatives(boolean sym) {
            this.sym = sym;
            return this;
        }

        public Builder useScalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            if (!scalingFactor) {
                this.log = true;
            }
            return this;
        }

        public SsfFunction<S, F> build() {
            return new SsfFunction<S, F>(this.data, this.X, this.diffuseElements, this.mapping, this.builder, this.ml, this.log, this.fast, this.sqr, this.mt, this.sym, this.scalingFactor);
        }
    }
}

