/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.ckms;

import jdplus.toolkit.base.core.ssf.ckms.CkmsInitializer;
import jdplus.toolkit.base.core.ssf.ckms.CkmsState;

public class CkmsArrayFilter {

    static class UMatrix {
        double R;
        double Z;
        double[] K;
        double[] L;
        private static final double EPS = 1.0E-15;
        private int pos;
        private int end;
        private int dim;
        private int ndiffuse;
        private final UMatrix matrix = new UMatrix();
        private CkmsState state;
        private CkmsInitializer initializer;

        UMatrix() {
        }

        boolean triangularize() {
            double jsigma = -this.Z * this.Z;
            if (-jsigma <= 1.0E-15) {
                return true;
            }
            double xJx = jsigma + this.R * this.R;
            if (xJx <= 0.0) {
                return false;
            }
            double jnrm = Math.sqrt(xJx);
            double v = -jsigma / (this.R + jnrm);
            double w = this.Z;
            this.R = jnrm;
            this.Z = 0.0;
            double beta = 2.0 / (jsigma + v * v);
            int nr = this.K.length;
            int k = 0;
            while (k < nr) {
                double s = (this.K[k] * v - this.L[k] * w) * beta;
                int n = k;
                this.K[n] = this.K[n] - s * v;
                int n2 = k++;
                this.L[n2] = this.L[n2] - s * w;
            }
            return true;
        }
    }
}

