/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.polynomials;

import internal.toolkit.base.core.math.polynomials.Coefficients;
import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import lombok.Generated;

public final class Polynomials {
    public static double[] divide(double[] num, double[] denom) {
        int n;
        int nv = denom.length - 1;
        for (n = num.length - 1; n >= 0 && !(Math.abs(num[n]) > 1.0E-9); --n) {
        }
        if (n < 0) {
            return Coefficients.zero();
        }
        while (nv >= 0 && !(Math.abs(denom[nv]) > 1.0E-9)) {
            --nv;
        }
        if (nv < 0) {
            if (num[n] > 0.0) {
                return Coefficients.positiveInfinity();
            }
            if (num[n] < 0.0) {
                return Coefficients.negativeInfinity();
            }
            return Coefficients.nan();
        }
        if (nv > n) {
            return Coefficients.zero();
        }
        double[] r = (double[])num.clone();
        double[] q = new double[n + 1];
        for (int k = n - nv; k >= 0; --k) {
            q[k] = r[nv + k] / denom[nv];
            for (int j = nv + k - 1; j >= k; --j) {
                int n2 = j;
                r[n2] = r[n2] - q[k] * denom[j - k];
            }
        }
        return Arrays.copyOf(q, n - nv + 1);
    }

    public static double evaluate(double[] c, double x) {
        int p = c.length - 1;
        double y = c[p--];
        while (p >= 0) {
            y = c[p] + y * x;
            --p;
        }
        return y;
    }

    public static double evaluate(int degree, IntToDoubleFunction fn, double x) {
        int p = degree;
        double y = fn.applyAsDouble(p--);
        while (p >= 0) {
            y = fn.applyAsDouble(p) + y * x;
            --p;
        }
        return y;
    }

    public static double[] plus(double[] l, double[] r) {
        if (l.length < r.length) {
            return Polynomials.plus(r, l);
        }
        double[] result = (double[])l.clone();
        for (int i = 0; i < r.length; ++i) {
            int n = i;
            result[n] = result[n] + r[i];
        }
        return result;
    }

    public static double[] minus(double[] l, double[] r) {
        int i;
        if (l.length >= r.length) {
            double[] result = (double[])l.clone();
            for (int i2 = 0; i2 < r.length; ++i2) {
                int n = i2;
                result[n] = result[n] - r[i2];
            }
            return result;
        }
        double[] result = new double[r.length];
        for (i = 0; i < l.length; ++i) {
            result[i] = l[i] - r[i];
        }
        for (i = l.length; i < r.length; ++i) {
            result[i] = -r[i];
        }
        return result;
    }

    public static double[] times(double[] l, double[] r) {
        int d = l.length + r.length - 1;
        double[] result = new double[d];
        for (int u = 0; u < l.length; ++u) {
            if (l[u] == 0.0) continue;
            for (int v = 0; v < r.length; ++v) {
                if (r[v] == 0.0) continue;
                int n = u + v;
                result[n] = result[n] + l[u] * r[v];
            }
        }
        return result;
    }

    @Generated
    private Polynomials() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

