/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class Absolute
extends AbstractBinIntSConstraint {
    public Absolute(IntDomainVar x0, IntDomainVar x1) {
        super(x0, x1);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate() throws ContradictionException {
        int valeur;
        DisposableIntIterator it;
        this.v0.updateInf(0, this, false);
        if (this.v0.getDomain().isEnumerated()) {
            IntDomain dom0 = this.v0.getDomain();
            it = dom0.getIterator();
            try {
                while (it.hasNext()) {
                    valeur = it.next();
                    if (this.v1.canBeInstantiatedTo(valeur) || this.v1.canBeInstantiatedTo(-valeur)) continue;
                    this.v0.removeVal(valeur, this, false);
                }
            }
            finally {
                it.dispose();
            }
        } else {
            this.awakeOnInf(1);
            this.awakeOnSup(1);
        }
        if (this.v1.getDomain().isEnumerated()) {
            IntDomain dom1 = this.v1.getDomain();
            it = dom1.getIterator();
            try {
                while (it.hasNext()) {
                    valeur = it.next();
                    if (this.v0.canBeInstantiatedTo(valeur) || this.v0.canBeInstantiatedTo(-valeur)) continue;
                    this.v1.removeVal(valeur, this, false);
                    this.v1.removeVal(-valeur, this, false);
                }
            }
            finally {
                it.dispose();
            }
        } else {
            this.awakeOnInf(0);
            this.awakeOnSup(0);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            if (this.v1.getInf() >= 0) {
                this.v1.updateInf(this.v0.getInf(), this, false);
            } else if (this.v1.getSup() <= 0) {
                this.v1.updateSup(-this.v0.getInf(), this, false);
            } else if (this.v1.getInf() > -this.v0.getInf()) {
                this.v1.updateInf(this.v0.getInf(), this, false);
            } else if (this.v1.getSup() < this.v0.getInf()) {
                this.v1.updateSup(-this.v0.getInf(), this, false);
            } else if (this.v1.getDomain().isEnumerated()) {
                this.v1.removeInterval(-this.v0.getInf() + 1, this.v0.getInf() - 1, this, false);
            }
        } else if (!this.v1.getDomain().isEnumerated() && this.v1.getInf() > -this.v0.getInf() && this.v1.getInf() < this.v0.getInf()) {
            this.v1.updateInf(this.v0.getInf(), this, true);
        } else if (this.v1.getInf() >= 0) {
            this.v0.updateInf(this.v1.getInf(), this, false);
            this.v0.updateSup(this.v1.getSup(), this, false);
            this.detectSymetricalHoles(this.v1.getInf(), this.v1.getSup());
        } else if (this.v1.getSup() <= 0) {
            this.v0.updateSup(-this.v1.getInf(), this, false);
            this.v0.updateInf(-this.v1.getSup(), this, false);
        } else {
            this.v0.updateSup(Math.max(-this.v1.getInf(), this.v1.getSup()), this, false);
            this.detectSymetricalHoles(-this.v1.getInf(), this.v1.getSup());
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v1.updateSup(this.v0.getSup(), this, false);
            this.v1.updateInf(-this.v0.getSup(), this, false);
        } else if (!this.v1.getDomain().isEnumerated() && this.v1.getSup() > -this.v0.getInf() && this.v1.getSup() < this.v0.getInf()) {
            this.v1.updateSup(-this.v0.getInf(), this, true);
        } else if (this.v1.getInf() >= 0) {
            this.v0.updateSup(this.v1.getSup(), this, false);
            this.v0.updateInf(this.v1.getInf(), this, false);
        } else if (this.v1.getSup() <= 0) {
            this.v0.updateInf(-this.v1.getSup(), this, false);
            this.v0.updateSup(-this.v1.getInf(), this, false);
            this.detectSymetricalHoles(-this.v1.getSup(), -this.v1.getInf());
        } else {
            this.v0.updateSup(Math.max(-this.v1.getInf(), this.v1.getSup()), this, false);
            this.detectSymetricalHoles(this.v1.getSup(), -this.v1.getInf());
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int val = this.v0.getVal();
            if (!this.v1.canBeInstantiatedTo(val)) {
                this.v1.instantiate(-val, this, false);
            } else if (!this.v1.canBeInstantiatedTo(-val)) {
                this.v1.instantiate(val, this, false);
            } else if (val >= 0) {
                this.v1.updateSup(val, this, false);
                this.v1.updateInf(-val, this, false);
                this.v1.removeInterval(-val + 1, val - 1, this, false);
            } else {
                this.v1.updateInf(val, this, false);
                this.v1.updateSup(-val, this, false);
                this.v1.removeInterval(val + 1, -val - 1, this, false);
            }
        } else {
            this.v0.instantiate(Math.abs(this.v1.getVal()), this, false);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            if (x >= 0) {
                this.v1.removeVal(x, this, false);
                this.v1.removeVal(-x, this, false);
                this.updateMinFromHoles();
            }
        } else if (!this.v1.canBeInstantiatedTo(-x)) {
            this.v0.removeVal(Math.abs(x), this, false);
        }
    }

    protected void detectSymetricalHoles(int inf, int sup) throws ContradictionException {
        if (this.v1.getDomain().isEnumerated()) {
            IntDomain dom0 = this.v0.getDomain();
            int valeur = Math.max(inf, this.v0.getInf());
            while (valeur <= Math.min(sup, this.v0.getSup())) {
                if (!this.v1.canBeInstantiatedTo(valeur) && !this.v1.canBeInstantiatedTo(-valeur)) {
                    this.v0.removeVal(valeur, this, false);
                }
                valeur = dom0.getNextValue(valeur);
            }
        }
    }

    protected void updateMinFromHoles() throws ContradictionException {
        if (this.v1.getDomain().isEnumerated() && this.v1.getInf() < 0 && this.v1.getSup() > 0) {
            int minPositiveValue = this.v1.getDomain().getNextValue(-1);
            int maxNegativeValue = this.v1.getDomain().getPrevValue(1);
            this.v0.updateInf(Math.min(-maxNegativeValue, minPositiveValue), this, false);
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() < 0) {
            return Boolean.FALSE;
        }
        if (this.v0.isInstantiated()) {
            if (this.v1.isInstantiated()) {
                return this.v0.getVal() == Math.abs(this.v1.getVal());
            }
            if (this.v1.getDomainSize() == 2 && this.v1.canBeInstantiatedTo(this.v0.getVal()) && this.v1.canBeInstantiatedTo(-this.v0.getVal())) {
                return Boolean.TRUE;
            }
            if (!this.v1.canBeInstantiatedTo(this.v0.getVal()) && !this.v1.canBeInstantiatedTo(-this.v0.getVal())) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return Math.abs(tuple[1]) == tuple[0];
    }

    @Override
    public boolean isConsistent() {
        throw new UnsupportedOperationException("Absolute.isConsistent is not implemented!");
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        throw new UnsupportedOperationException("Absolute.opposite is not implemented!");
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" = |");
        sb.append(this.v1.toString());
        sb.append("| ");
        return sb.toString();
    }
}

