/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.internalConstraints;

import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.ForbiddenRegion;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Logger;

public final class DistGeqIC
extends ForbiddenRegion {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public int q;
    public int D;
    public int s1;
    public int s2;
    public int o1;
    public int o2;
    IntDomainVar DVar = null;
    public Setup stp;

    public DistGeqIC(Setup stp_, int q_, int D_, int s1_, int s2_, int o1_, int o2_) {
        this.setIctrID(6);
        this.stp = stp_;
        this.q = q_;
        this.D = D_;
        this.s1 = s1_;
        this.s2 = s2_;
        this.o1 = o1_;
        this.o2 = o2_;
        if (this.q != 2) {
            throw new SolverException("DistGeqIC:Only norm 2 is supported for now.");
        }
    }

    public DistGeqIC(Setup stp_, int q_, int D_, int s1_, int s2_, int o1_, int o2_, IntDomainVar DVar_) {
        this.setIctrID(6);
        this.stp = stp_;
        this.q = q_;
        this.D = D_;
        this.s1 = s1_;
        this.s2 = s2_;
        this.o1 = o1_;
        this.o2 = o2_;
        if (this.q != 2) {
            throw new SolverException("DistGeqIC:Only norm 2 is supported for now.");
        }
        this.DVar = DVar_;
    }

    @Override
    public boolean insideForbidden(Point p) {
        if (this.DVar != null) {
            this.D = this.DVar.getInf();
        }
        int k = p.getCoords().length;
        Point m = new Point(k);
        for (int i = 0; i < k; ++i) {
            int p_i = p.getCoord(i);
            int s1_t_i = this.stp.getShape(this.s1).get(0).getOffset(i);
            int s2_t_i = this.stp.getShape(this.s2).get(0).getOffset(i);
            int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
            int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
            int s1_l_i = this.stp.getShape(this.s1).get(0).getSize(i);
            int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
            int N1 = Math.max(p_i + s1_t_i, o2_x_i_ub + s2_t_i);
            int N2 = Math.min(p_i + s1_t_i + s1_l_i, o2_x_i_ub + s1_t_i + s2_l_i);
            int M1 = Math.max(0, N1 - N2);
            int N1_ = Math.max(p_i + s1_t_i, o2_x_i_lb + s2_t_i);
            int N2_ = Math.min(p_i + s1_t_i + s1_l_i, o2_x_i_lb + s2_t_i + s2_l_i);
            int M2 = Math.max(0, N1_ - N2_);
            m.setCoord(i, Math.max(M1, M2));
        }
        double norm = this.norm(m);
        return norm < (double)this.D;
    }

    @Override
    public int maximizeSizeOfFBox(boolean min, int d, int k, Region f) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            if (!this.insideForbidden(f.pointMin())) {
                throw new SolverException("Error precondition pointMin in DistGeqIC");
            }
            if (!this.insideForbidden(f.pointMax())) {
                throw new SolverException("Error precondition pointMax in DistGeqIC");
            }
        }
        if (this.DVar != null) {
            this.D = this.DVar.getInf();
        }
        Point m = new Point(k);
        for (int i = 0; i < k; ++i) {
            int f_min_i = f.getMinimumBoundary(i);
            int f_max_i = f.getMaximumBoundary(i);
            int s1_t_i = this.stp.getShape(this.s1).get(0).getOffset(i);
            int s2_t_i = this.stp.getShape(this.s2).get(0).getOffset(i);
            int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
            int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
            int s1_l_i = this.stp.getShape(this.s1).get(0).getSize(i);
            int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
            int N1 = Math.max(f_min_i + s1_t_i, o2_x_i_ub + s2_t_i);
            int N2 = Math.min(f_min_i + s1_t_i + s1_l_i, o2_x_i_ub + s1_t_i + s2_l_i);
            int M1 = Math.max(0, N1 - N2);
            int N1_ = Math.max(f_max_i + s1_t_i, o2_x_i_lb + s2_t_i);
            int N2_ = Math.min(f_max_i + s1_t_i + s1_l_i, o2_x_i_lb + s2_t_i + s2_l_i);
            int M2 = Math.max(0, N1_ - N2_);
            m.setCoord(i, Math.max(M1, M2));
        }
        int s1_t_d = this.stp.getShape(this.s1).get(0).getOffset(d);
        int s2_t_d = this.stp.getShape(this.s2).get(0).getOffset(d);
        int o2_x_d_lb = this.stp.getObject(this.o2).getCoord(d).getInf();
        int o2_x_d_ub = this.stp.getObject(this.o2).getCoord(d).getSup();
        int s1_l_d = this.stp.getShape(this.s1).get(0).getSize(d);
        int s2_l_d = this.stp.getShape(this.s2).get(0).getSize(d);
        double q_sum = this.q_sum(m, d);
        double term = this.sqrt(Math.pow(this.D, this.q) - q_sum);
        if (term >= 0.0) {
            this.checkSqrt(Math.pow(this.D, this.q) - q_sum, term);
        }
        if (min) {
            return (int)Math.ceil(term + (double)o2_x_d_lb + (double)s2_t_d + (double)s2_l_d) - 1 - s1_t_d;
        }
        return (int)Math.floor((double)(o2_x_d_ub + s2_t_d + s1_l_d) - term) + 1 - s1_t_d;
    }

    private double q_sum(Point m, int d) {
        int k = m.getCoords().length;
        double sum = 0.0;
        for (int i = k - 1; i >= 0; --i) {
            if (i == d) continue;
            double r = 1.0;
            for (int j = 0; j < this.q; ++j) {
                if ((r *= (double)Math.abs(m.getCoord(i))) != Double.POSITIVE_INFINITY) continue;
                throw new SolverException("DestGeqIC:q_sum():r:double limit reached");
            }
            if ((sum += r) != Double.POSITIVE_INFINITY) continue;
            throw new SolverException("DestGeqIC:q_sum():sum:double limit reached");
        }
        return sum;
    }

    private double sqrt(double sum) {
        return Math.sqrt(sum);
    }

    private double norm(Point m) {
        return this.sqrt(this.q_sum(m, -1));
    }

    private void checkSqrt(double value, double result) {
        if (value < 0.0) {
            throw new SolverException("DistGeqIC:checkSqrt(): value is negative:" + value);
        }
        double ivalue = Math.floor(value);
        if (ivalue != value) {
            throw new SolverException("DistGeqIC:checkSqrt(): sqrt value is not an integer double value:" + value + " integer value:" + ivalue);
        }
        long lb = (int)Math.floor(result);
        long ub = (int)Math.ceil(result);
        if ((double)(lb * lb) > ivalue) {
            throw new SolverException("DistGeqIC:checkSqrt(): lb is wrong:" + value + "," + result);
        }
        if ((double)(ub * ub) < ivalue) {
            throw new SolverException("DistGeqIC:checkSqrt(): ub is wrong:ub:" + ub + " value:" + value + "," + result + " ub*ub:" + ub * ub + "<ivalue:" + ivalue);
        }
    }

    public boolean insideForbidden(Point c0, Point c1) {
        if (this.DVar != null) {
            this.D = this.DVar.getInf();
        }
        return this.insideForbidden(c0) && this.insideForbidden(c1);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.DVar == null) {
            r.append("GeqIC(D=").append(this.D).append(",q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        } else {
            r.append("GeqIC(D=[").append(this.DVar.getInf()).append(",").append(this.DVar.getSup()).append("],q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        }
        return r.toString();
    }

    public int EvaluateMaximumDistance(int k) {
        double dist = 0.0;
        for (int d = 0; d < k; ++d) {
            int o1_inf = this.stp.getObject(this.o1).getCoord(d).getInf();
            int o2_inf = this.stp.getObject(this.o2).getCoord(d).getInf();
            int o1_sup = this.stp.getObject(this.o1).getCoord(d).getSup();
            int o2_sup = this.stp.getObject(this.o2).getCoord(d).getSup();
            double m1 = Math.max(o1_inf, o2_sup) - Math.min(o1_inf, o2_sup);
            double m2 = Math.max(o1_sup, o2_inf) - Math.min(o1_sup, o2_inf);
            double max = Math.max(m1, m2);
            dist += max * max;
        }
        return (int)Math.floor(Math.sqrt(dist));
    }

    public boolean updateDistance(int k) throws ContradictionException {
        if (this.DVar != null) {
            int newSup;
            int oldSup = this.DVar.getSup();
            if (oldSup <= (newSup = this.EvaluateMaximumDistance(k))) {
                return false;
            }
            this.DVar.updateSup(newSup, this.stp.g_constraint, false);
            GeostOptions cfr_ignored_0 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("DistGeqIC:" + this + " updateDistance:[" + this.DVar.getInf() + "," + this.DVar.getSup() + "]");
            }
            if (this.DVar.getInf() > this.DVar.getSup() || this.DVar.getSup() < this.DVar.getInf()) {
                this.stp.propagationEngine.raiseContradiction(null);
            }
            return true;
        }
        return false;
    }

    public boolean hasDistanceVar() {
        return this.DVar != null;
    }

    public IntDomainVar getDistanceVar() {
        return this.DVar;
    }
}

