# epidm <img src="man/figures/logo.png" align="right" height="139" alt="" />

<!-- badges: start -->
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-green.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![R-CMD-check](https://github.com/ukhsa-collaboration/epidm/actions/workflows/R-CMD-check.yaml/badge.svg?branch=master)](https://github.com/ukhsa-collaboration/epidm/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

`epidm` provides standard methods for the management and transformation of UK Public Health data in R

## Installation

epiviz can be installed from GitHub using the following code:
```r
# Install epidm
remotes::install_github('ukhsa-collaboration/epidm')

# To install the development version
remotes::install_github("ukhsa-collaboration/epidm@dev")
``` 

## Purpose

The `epidm` package has been developed to share standard methods for the 
processing of epidemiological data in the UK. Key data assets this focuses on include

### Infection data

The Second Generation Surveillance System (SGSS) is a data asset held by the [UK Health Security Agency](https://www.gov.uk/government/publications/securing-our-health-the-uk-health-security-agency/securing-our-health-the-uk-health-security-agency) (formerly Public Health England) which routinely and automatically collects laboratory data from across England.

Laboratories return data on organisms isolated from samples such as the organism species, specimen type, sampling date and antimicrobial susceptibility testing results. These data are routinely used for public health surveillance and epidemiology in England. 

### Hospital data

The functions for dealing with hospital data within `epidm` are designed to help clean, process, and link the hospital in a meaningful way. These methods have been used to help understand [Healthcare Associated COVID-19 in England](https://www.medrxiv.org/content/10.1101/2021.02.16.21251625v1).

#### [Emergency Care Data Set (ECDS)](https://digital.nhs.uk/data-and-information/data-collections-and-data-sets/data-sets/emergency-care-data-set-ecds)
ECDS is the national data set for urgent and emergency care and is reported daily by NHS Trusts.

#### [Secondary Use Services (SUS)](https://digital.nhs.uk/services/secondary-uses-service-sus)
SUS is the single, comprehensive repository for healthcare data in England which enables a range of reporting and analyses to support the NHS in the delivery of healthcare services.
SUS is reported monthly, by the 21st of each month for the previous months data.

#### [Hospital Episode Statistics (HES)](https://digital.nhs.uk/data-and-information/data-tools-and-services/data-services/hospital-episode-statistics)
HES is a data warehouse containing details of all admissions, outpatient appointments and A and E attendances at NHS hospitals in England.
Hes is reported quarterly, and is a 'cleaned' version of SUS and ECDS.
