/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Clas.problem.errorfunctions;

import keel.Algorithms.Neural_Networks.NNEP_Common.problem.errorfunctions.IErrorFunction;

public class LogisticErrorFunction
implements IErrorFunction<double[][]> {
    @Override
    public double calculateError(double[][] obtained, double[][] expected) {
        double logError = 0.0;
        for (int i = 0; i < obtained[0].length; ++i) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int j = 0; j < obtained.length; ++j) {
                sum1 += expected[j][i] * obtained[j][i];
                sum2 += Math.exp(obtained[j][i]);
            }
            logError += -sum1 + Math.log(sum2);
        }
        if (Double.isInfinite(logError /= (double)obtained[0].length) || Double.isNaN(logError)) {
            logError = Double.MAX_VALUE;
        }
        return logError;
    }
}

