/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DTest;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

public class DenseLargeDoubleMatrix2DTest
extends DoubleMatrix2DTest {
    public DenseLargeDoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseLargeDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseLargeDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseLargeDoubleMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testDct2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dct2(true);
        ((WrapperDoubleMatrix2D)this.A).idct2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDctColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dctColumns(true);
        ((WrapperDoubleMatrix2D)this.A).idctColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDctRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dctRows(true);
        ((WrapperDoubleMatrix2D)this.A).idctRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDht2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dht2();
        ((WrapperDoubleMatrix2D)this.A).idht2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDhtColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dhtColumns();
        ((WrapperDoubleMatrix2D)this.A).idhtColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDhtRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dhtRows();
        ((WrapperDoubleMatrix2D)this.A).idhtRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDst2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dst2(true);
        ((WrapperDoubleMatrix2D)this.A).idst2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDstColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dstColumns(true);
        ((WrapperDoubleMatrix2D)this.A).idstColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testDstRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        ((WrapperDoubleMatrix2D)this.A).dstRows(true);
        ((WrapperDoubleMatrix2D)this.A).idstRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testFft2() {
        int n;
        int n2;
        int n3 = 64;
        int n4 = 128;
        DoubleMatrix2D doubleMatrix2D = new DenseLargeDoubleMatrix2D(n3, n4);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        ((DenseLargeDoubleMatrix2D)doubleMatrix2D).fft2();
        ((DenseLargeDoubleMatrix2D)doubleMatrix2D).ifft2(true);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D2.getQuick(n2, n), (double)doubleMatrix2D.getQuick(n2, n), (double)this.TOL);
            }
        }
        doubleMatrix2D = doubleMatrix2D.viewDice();
        doubleMatrix2D2 = doubleMatrix2D.copy();
        ((WrapperDoubleMatrix2D)doubleMatrix2D).fft2();
        ((WrapperDoubleMatrix2D)doubleMatrix2D).ifft2(true);
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D2.getQuick(n2, n), (double)doubleMatrix2D.getQuick(n2, n), (double)this.TOL);
            }
        }
    }

    public void testGetFft2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getFft2();
        denseLargeDComplexMatrix2D.ifft2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfft2() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getIfft2(true);
        denseLargeDComplexMatrix2D.fft2();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetFftColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getFftColumns();
        denseLargeDComplexMatrix2D.ifftColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfftColumns() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getIfftColumns(true);
        denseLargeDComplexMatrix2D.fftColumns();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetFftRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getFftRows();
        denseLargeDComplexMatrix2D.ifftRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }

    public void testGetIfftRows() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = ((WrapperDoubleMatrix2D)this.A).getIfftRows(true);
        denseLargeDComplexMatrix2D.fftRows();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double[] dArray = ((DComplexMatrix2D)denseLargeDComplexMatrix2D).getQuick(i, j);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)dArray[0], (double)this.TOL);
                DenseLargeDoubleMatrix2DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
            }
        }
    }
}

