## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, eval=TRUE, echo=FALSE, warning=FALSE, message=FALSE---------------
library(FFdownload)
outd <- paste0(tempdir(),"/",format(Sys.time(), "%F_%H-%M"))
outfile <- paste0(outd,"FFData_xts.RData")
listfile <- paste0(outd,"FFList.txt")

## ----setup2, eval=FALSE, echo=TRUE--------------------------------------------
# library(FFdownload)
# outd     <- paste0("data/", format(Sys.time(), "%F_%H-%M"))
# outfile  <- paste0(outd, "FFData_xts.RData")
# listfile <- paste0(outd, "FFList.txt")

## ----xts_fflist, eval=FALSE---------------------------------------------------
# fl <- FFlist(exclude_daily = TRUE)
# nrow(fl)   # 100+ non-daily datasets
# head(fl)
# 
# # Filter with dplyr
# library(dplyr)
# fl |> filter(grepl("Momentum|Reversal|5_Factors", name))

## ----xts_list_save------------------------------------------------------------
FFdownload(exclude_daily=TRUE, download=FALSE, download_only=TRUE, listsave=listfile)
read.delim(listfile, sep=",")[c(1:4, 73:74), ]

## ----xts_ffmatch, eval=FALSE--------------------------------------------------
# FFmatch(c("F-F_Research_Data_Factors_CSV", "F-F_Momentum_Factor_CSV"))

## ----xts_download-------------------------------------------------------------
inputlist <- c("F-F_Research_Data_Factors_CSV","F-F_Momentum_Factor_CSV")
FFdownload(exclude_daily=TRUE, tempd=outd, download=TRUE, download_only=TRUE, inputlist=inputlist)
list.files(outd)

## ----xts_download_action, eval=FALSE------------------------------------------
# FFdownload(exclude_daily=TRUE, tempd=outd, action="download_only", inputlist=inputlist)

## ----xts_download_cache, eval=FALSE-------------------------------------------
# # Reuse any cached file younger than 7 days; only download if stale
# FFdownload(exclude_daily=TRUE, tempd=outd, action="download_only",
#            inputlist=inputlist, cache_days=7)

## ----xts_processing-----------------------------------------------------------
FFdownload(exclude_daily=TRUE, tempd=outd, download=FALSE, download_only=FALSE,
           inputlist=inputlist, output_file=outfile)

## ----xts_return_data, eval=FALSE----------------------------------------------
# FFdata <- FFdownload(exclude_daily=TRUE, tempd=outd, download=FALSE,
#                      download_only=FALSE, inputlist=inputlist,
#                      output_file=outfile, return_data=TRUE)

## ----xts_na_values, eval=FALSE------------------------------------------------
# FFdownload(exclude_daily=TRUE, tempd=outd, download=FALSE, download_only=FALSE,
#            inputlist=inputlist, output_file=outfile,
#            na_values=c(-99, -999, -99.99))

## ----xts_load-----------------------------------------------------------------
load(outfile)
ls.str(FFdata)

## ----xts_names, eval=FALSE----------------------------------------------------
# # Discover sub-table names for the factors dataset
# names(FFdata[["x_F-F_Research_Data_Factors"]]$monthly)
# #> [1] "Temp2"
# names(FFdata[["x_F-F_Research_Data_Factors"]]$annual)
# #> [1] "annual_factors:_january-december"

## ----xts_process, eval=FALSE, echo=TRUE---------------------------------------
# monthly         <- do.call(merge, lapply(FFdata, function(i) i$monthly$Temp2))
# monthly_1963    <- na.omit(monthly)["1963/"]
# monthly_returns <- cumprod(1 + monthly_1963 / 100) - 1
# plot(monthly_returns)

## ----xts_process2, eval=TRUE, echo=FALSE, out.width="100%", fig.width=8, fig.height=4----
monthly         <- do.call(merge, lapply(FFdata, function(i) i$monthly$Temp2))
monthly_1963    <- na.omit(monthly)["1963/"]
monthly_returns <- cumprod(1 + monthly_1963 / 100) - 1
plot(monthly_returns, col=viridis::viridis(5, direction=-1),
     legend.loc="topleft", lwd=2,
     main="Fama-French & Carhart Factor Wealth Index")

