# dependencies
library(stringr)
library(dplyr)
library(ggplot2)

# data from Stack Exchange
# https://stats.stackexchange.com/questions/76663/john-kerrich-coin-flip-data/77044#77044

kerrichRaw <- "00011101001111101000110101111000100111001000001110
00101010100100001001100010000111010100010000101101
01110100001101001010000011111011111001101100101011
01010000011000111001111101101010110100110110110110
01111100001110110001010010000010100111111011101011
10001100011000110001100110100100001000011101111000
11111110000000001101011010011111011110010010101100
11101101110010000010001100101100111110100111100010
00001001101011101010110011111011001000001101011111
11010001111110010111111001110011111111010000100000
00001111100101010111100001110111001000110100001111
11000101001111111101101110110111011010010110110011
01010011011111110010111000111101111111000001001001
01001110111011011011111100000101010101010101001001
11101101110011100000001001101010011001000100001100
10111100010011010110110111001101001010100000010000
00001011001101011011111000101100101000011100110011
11100101011010000110001001100010010001100100001001
01000011100000011101101111001110011010101101001011
01000001110110100010001110010011100001010000000010
10010001011000010010100011111101101111010101010000
01100010100000100000000010000001100100011011101010
11011000110111010110010010111000101101101010110110
00001011011101010101000011100111000110100111011101
10001101110000010011110001110100001010000111110100
00111111111111010101001001100010111100101010001111
11000110101010011010010111110000111011110110011001
11111010000011101010111101101011100001000101101001
10011010000101111101111010110011011110000010110010
00110110101111101011100101001101100100011000011000
01010011000110100111010000011001100011101011100001
11010111011110101101101111001111011100011011010000
01011110100111011001001110001111011000011110011111
01101011101110011011100011001111001011101010010010
10100011010111011000111110000011000000010011101011
10001011101000101111110111000001111111011000000010
10111111011100010000110000110001111101001110110000
00001111011100011101010001011000110111010001110111
10000010000110100000101000010101000101100010111100
00101110010111010010110010110100011000001110000111"

# parse paragraph
kerrich <- data.frame(matrix(unlist(str_split(kerrichRaw, ""))))
rm(kerrichRaw)

# clean data frame
kerrich %>%
  rename(outcome = matrix.unlist.str_split.kerrichRaw.......) %>%
  filter(outcome == 0 | outcome == 1) %>%
  mutate(outcome = ifelse(outcome == 1,TRUE,FALSE)) %>%
  mutate(average = cummean(outcome)) -> kerrich

kerrich %>%
  mutate(id = as.numeric(rownames(kerrich))) %>%
  select(id, outcome, average) -> kerrich

# save data
save(kerrich, file="data/kerrich.rda")
