/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regular.tests;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.linearmodel.JointTest;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import lombok.Generated;

public final class TradingDaysTest {
    public static StatisticalTest olsTest(TsData y, int ... lags) {
        try {
            GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)DayClustering.TD7);
            GenericTradingDaysVariable td = new GenericTradingDaysVariable(gtd);
            FastMatrix m = Regression.matrix(y.getDomain(), new ITsVariable[]{td});
            DoubleSeq dy = y.getValues();
            FastMatrix dm = m;
            if (lags != null) {
                for (int j = 0; j < lags.length; ++j) {
                    int lag = lags[j];
                    if (lag <= 0) continue;
                    FastMatrix mj = dm;
                    int nr = mj.getRowsCount();
                    int nc = mj.getColumnsCount();
                    dm = mj.extract(lag, nr - lag, 0, nc).deepClone();
                    dm.sub(mj.extract(0, nr - lag, 0, nc));
                    dy = dy.delta(lag);
                }
            }
            dy = dy.plus(-dy.average());
            LinearModel reg = LinearModel.builder().y(dy).addX((Matrix)dm).build();
            LeastSquaresResults lsr = Ols.compute(reg);
            return lsr.Ftest();
        }
        catch (Exception err) {
            return null;
        }
    }

    public static StatisticalTest maTest(TsData y, boolean seas) {
        try {
            SarimaOrders orders;
            GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)DayClustering.TD7);
            GenericTradingDaysVariable td = new GenericTradingDaysVariable(gtd);
            FastMatrix m = Regression.matrix(y.getDomain(), new ITsVariable[]{td});
            if (seas) {
                orders = SarimaOrders.airline((int)y.getAnnualFrequency());
            } else {
                orders = new SarimaOrders(y.getAnnualFrequency());
                orders.setD(1);
                orders.setQ(1);
            }
            RegArimaModel<SarimaModel> regarima = RegArimaModel.builder().y(y.getValues()).addX(m).arima(SarimaModel.builder(orders).setDefault().build()).build();
            RegArimaEstimation<SarimaModel> rslt = RegSarimaComputer.PROCESSOR.process(regarima, (IArimaMapping<SarimaModel>)null);
            return new JointTest(rslt.getConcentratedLikelihood()).hyperParametersCount(seas ? 2 : 1).build();
        }
        catch (Exception err) {
            return null;
        }
    }

    @Generated
    private TradingDaysTest() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

