/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.costStrutures;

import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.costStrutures.ShortestPaths;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.Solver;
import java.util.logging.Logger;

public class CostStructure {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected boolean affichecosts = false;
    protected int nbNodes;
    protected Solver solver;
    protected VarGraphView inputGraph;
    protected ShortestPaths path;
    protected IStateInt[][] cost;
    protected IStateInt[][] minCost;
    protected IStateInt forestCost;
    protected IStateInt[] deltaCost;

    public CostStructure(Solver solver, TreeParameters tree, VarGraphView inputGraph) {
        int i;
        this.solver = solver;
        this.nbNodes = inputGraph.getNbNodes();
        this.inputGraph = inputGraph;
        this.cost = tree.getTravelTime();
        this.minCost = new IStateInt[this.nbNodes][this.nbNodes];
        for (i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                this.minCost[i][j] = solver.getEnvironment().makeInt(0);
            }
        }
        this.path = new ShortestPaths(this.nbNodes, this.cost, inputGraph, this.minCost);
        this.forestCost = solver.getEnvironment().makeInt(Integer.MAX_VALUE);
        this.deltaCost = new IStateInt[this.nbNodes];
        for (i = 0; i < this.nbNodes; ++i) {
            this.deltaCost[i] = solver.getEnvironment().makeInt(0);
        }
    }

    public IStateInt[][] getCost() {
        return this.cost;
    }

    public IStateInt[][] getMinCost() {
        return this.minCost;
    }

    public IStateInt getForestCost() {
        return this.forestCost;
    }

    public IStateInt[] getDeltaCost() {
        return this.deltaCost;
    }

    public void updateCostStruct() {
        this.path.computeMinPaths();
        IStateBitSet[] vertFromNumGt = this.inputGraph.getSure().getVertFromNumCC();
        if (this.affichecosts) {
            int i;
            for (i = 0; i < this.nbNodes; ++i) {
                LOGGER.info("cc_" + i + " = " + vertFromNumGt[i].toString());
            }
            LOGGER.info("- - - - - - - - - - - -");
            for (i = 0; i < this.nbNodes; ++i) {
                LOGGER.info("gt[" + i + "] = " + this.inputGraph.getSure().getSuccessors(i));
            }
            LOGGER.info("-------------------------------");
        }
        int[] connexComponentCosts = new int[this.nbNodes];
        int sinkOf = -1;
        int total = 0;
        for (int i = 0; i < this.nbNodes; ++i) {
            connexComponentCosts[i] = 0;
            if (vertFromNumGt[i].nextSetBit(0) <= -1) continue;
            int j = vertFromNumGt[i].nextSetBit(0);
            while (j >= 0) {
                if (this.inputGraph.isFixedSucc(j)) {
                    int val = this.inputGraph.getSure().getSuccessors(j).nextSetBit(0);
                    if (vertFromNumGt[i].get(val)) {
                        if (this.inputGraph.getPotentialRoots().get(j)) {
                            sinkOf = j;
                        }
                        int n = i;
                        connexComponentCosts[n] = connexComponentCosts[n] + this.cost[j][val].get();
                    } else {
                        sinkOf = j;
                    }
                } else {
                    sinkOf = j;
                }
                j = vertFromNumGt[i].nextSetBit(j + 1);
            }
            if (sinkOf == -1) {
                sinkOf = vertFromNumGt[i].nextSetBit(0);
            }
            this.deltaCost[i].set(this.getMinOutGoingArc(sinkOf));
            if (this.affichecosts) {
                LOGGER.info("\t\tconnexCompCosts[" + i + "] = " + connexComponentCosts[i]);
                LOGGER.info("\t\tdeltaCosts[" + i + "] = " + this.deltaCost[i].get());
            }
            total = total + connexComponentCosts[i] + this.deltaCost[i].get();
        }
        this.forestCost.set(total);
        if (this.affichecosts) {
            LOGGER.info("total cost = " + this.forestCost.get());
            LOGGER.info("-------------------------------");
        }
    }

    private int getMinOutGoingArc(int sink) {
        int minSucc = Integer.MAX_VALUE;
        if (this.inputGraph.isFixedSucc(sink) && this.inputGraph.getPotentialRoots().get(sink)) {
            minSucc = this.cost[sink][sink].get();
        } else {
            IStateBitSet maybe = this.inputGraph.getMaybe().getSuccessors(sink);
            int i = maybe.nextSetBit(0);
            while (i >= 0) {
                if (this.cost[sink][i].get() < minSucc) {
                    minSucc = this.cost[sink][i].get();
                }
                i = maybe.nextSetBit(i + 1);
            }
        }
        return minSucc;
    }
}

