/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.CharSequenceLowercase;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2PorterStems;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.CharSequenceLexer;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestTokenSequence2PorterStems
extends TestCase {
    public void testVector() {
        String vector = "exampl do you realli think it is weak that yield to temptat i tell you that there ar terribl temptat which it requir strength strength and courag to yield to oscar wild";
        SerialPipes pipes = this.createPipes();
        Instance instance = new Instance("Example:\nDo you really think it is weakness that yields to temptation? I tell you that there are terrible temptations which it requires strength, strength and courage to yield to ~ Oscar Wilde", null, null, null);
        InstanceList instances = new InstanceList(pipes);
        instances.addThruPipe(instance);
        TokenSequence tokenSequence = (TokenSequence)instance.getData();
        TestTokenSequence2PorterStems.assertEquals(32, tokenSequence.size());
        TestTokenSequence2PorterStems.assertEquals(vector, this.tokenSequence2String(tokenSequence));
    }

    public void testStep1a() {
        TestTokenSequence2PorterStems.assertEquals("caress", this.oneWordStem("caresses"));
        TestTokenSequence2PorterStems.assertEquals("poni", this.oneWordStem("ponies"));
        TestTokenSequence2PorterStems.assertEquals("ti", this.oneWordStem("ties"));
        TestTokenSequence2PorterStems.assertEquals("caress", this.oneWordStem("caress"));
        TestTokenSequence2PorterStems.assertEquals("cat", this.oneWordStem("cats"));
    }

    public void testStep1b() {
        TestTokenSequence2PorterStems.assertEquals("feed", this.oneWordStem("feed"));
        TestTokenSequence2PorterStems.assertEquals("agre", this.oneWordStem("agreed"));
        TestTokenSequence2PorterStems.assertEquals("plaster", this.oneWordStem("plastered"));
        TestTokenSequence2PorterStems.assertEquals("bled", this.oneWordStem("bled"));
        TestTokenSequence2PorterStems.assertEquals("motor", this.oneWordStem("motoring"));
        TestTokenSequence2PorterStems.assertEquals("sing", this.oneWordStem("sing"));
        TestTokenSequence2PorterStems.assertEquals("conflat", this.oneWordStem("conflated"));
        TestTokenSequence2PorterStems.assertEquals("troubl", this.oneWordStem("troubled"));
        TestTokenSequence2PorterStems.assertEquals("size", this.oneWordStem("sized"));
        TestTokenSequence2PorterStems.assertEquals("hop", this.oneWordStem("hopping"));
        TestTokenSequence2PorterStems.assertEquals("tan", this.oneWordStem("tanned"));
        TestTokenSequence2PorterStems.assertEquals("fall", this.oneWordStem("falling"));
        TestTokenSequence2PorterStems.assertEquals("hiss", this.oneWordStem("hissing"));
        TestTokenSequence2PorterStems.assertEquals("fizz", this.oneWordStem("fizzed"));
        TestTokenSequence2PorterStems.assertEquals("fail", this.oneWordStem("failing"));
        TestTokenSequence2PorterStems.assertEquals("file", this.oneWordStem("filing"));
    }

    public void testStep1c() {
        TestTokenSequence2PorterStems.assertEquals("happi", this.oneWordStem("happy"));
        TestTokenSequence2PorterStems.assertEquals("sky", this.oneWordStem("sky"));
    }

    public void testStep2() {
        TestTokenSequence2PorterStems.assertEquals("relat", this.oneWordStem("relational"));
        TestTokenSequence2PorterStems.assertEquals("condit", this.oneWordStem("conditional"));
        TestTokenSequence2PorterStems.assertEquals("ration", this.oneWordStem("rational"));
        TestTokenSequence2PorterStems.assertEquals("valenc", this.oneWordStem("valenci"));
        TestTokenSequence2PorterStems.assertEquals("hesit", this.oneWordStem("hesitanci"));
        TestTokenSequence2PorterStems.assertEquals("digit", this.oneWordStem("digitizer"));
        TestTokenSequence2PorterStems.assertEquals("conform", this.oneWordStem("conformabli"));
        TestTokenSequence2PorterStems.assertEquals("radic", this.oneWordStem("radicalli"));
        TestTokenSequence2PorterStems.assertEquals("differ", this.oneWordStem("differentli"));
        TestTokenSequence2PorterStems.assertEquals("vile", this.oneWordStem("vileli"));
        TestTokenSequence2PorterStems.assertEquals("analog", this.oneWordStem("analogousli"));
        TestTokenSequence2PorterStems.assertEquals("vietnam", this.oneWordStem("vietnamization"));
        TestTokenSequence2PorterStems.assertEquals("predic", this.oneWordStem("predication"));
        TestTokenSequence2PorterStems.assertEquals("oper", this.oneWordStem("operator"));
        TestTokenSequence2PorterStems.assertEquals("feudal", this.oneWordStem("feudalism"));
        TestTokenSequence2PorterStems.assertEquals("decis", this.oneWordStem("decisiveness"));
        TestTokenSequence2PorterStems.assertEquals("hope", this.oneWordStem("hopefulness"));
        TestTokenSequence2PorterStems.assertEquals("callous", this.oneWordStem("callousness"));
        TestTokenSequence2PorterStems.assertEquals("formal", this.oneWordStem("formaliti"));
        TestTokenSequence2PorterStems.assertEquals("sensit", this.oneWordStem("sensitiviti"));
        TestTokenSequence2PorterStems.assertEquals("sensibl", this.oneWordStem("sensibiliti"));
    }

    public void testStep3() {
        TestTokenSequence2PorterStems.assertEquals("triplic", this.oneWordStem("triplicate"));
        TestTokenSequence2PorterStems.assertEquals("form", this.oneWordStem("formative"));
        TestTokenSequence2PorterStems.assertEquals("formal", this.oneWordStem("formalize"));
        TestTokenSequence2PorterStems.assertEquals("electr", this.oneWordStem("electriciti"));
        TestTokenSequence2PorterStems.assertEquals("electr", this.oneWordStem("electrical"));
        TestTokenSequence2PorterStems.assertEquals("hope", this.oneWordStem("hopeful"));
        TestTokenSequence2PorterStems.assertEquals("good", this.oneWordStem("goodness"));
    }

    public void testStep4() {
        TestTokenSequence2PorterStems.assertEquals("reviv", this.oneWordStem("revival"));
        TestTokenSequence2PorterStems.assertEquals("allow", this.oneWordStem("allowance"));
        TestTokenSequence2PorterStems.assertEquals("infer", this.oneWordStem("inference"));
        TestTokenSequence2PorterStems.assertEquals("airlin", this.oneWordStem("airliner"));
        TestTokenSequence2PorterStems.assertEquals("gyroscop", this.oneWordStem("gyroscopic"));
        TestTokenSequence2PorterStems.assertEquals("adjust", this.oneWordStem("adjustable"));
        TestTokenSequence2PorterStems.assertEquals("defens", this.oneWordStem("defensible"));
        TestTokenSequence2PorterStems.assertEquals("irrit", this.oneWordStem("irritant"));
        TestTokenSequence2PorterStems.assertEquals("replac", this.oneWordStem("replacement"));
        TestTokenSequence2PorterStems.assertEquals("adjust", this.oneWordStem("adjustment"));
        TestTokenSequence2PorterStems.assertEquals("depend", this.oneWordStem("dependent"));
        TestTokenSequence2PorterStems.assertEquals("adopt", this.oneWordStem("adoption"));
        TestTokenSequence2PorterStems.assertEquals("homolog", this.oneWordStem("homologou"));
        TestTokenSequence2PorterStems.assertEquals("commun", this.oneWordStem("communism"));
        TestTokenSequence2PorterStems.assertEquals("activ", this.oneWordStem("activate"));
        TestTokenSequence2PorterStems.assertEquals("angular", this.oneWordStem("angulariti"));
        TestTokenSequence2PorterStems.assertEquals("homolog", this.oneWordStem("homologous"));
        TestTokenSequence2PorterStems.assertEquals("effect", this.oneWordStem("effective"));
        TestTokenSequence2PorterStems.assertEquals("bowdler", this.oneWordStem("bowdlerize"));
    }

    public void testStep5a() {
        TestTokenSequence2PorterStems.assertEquals("probat", this.oneWordStem("probate"));
        TestTokenSequence2PorterStems.assertEquals("rate", this.oneWordStem("rate"));
        TestTokenSequence2PorterStems.assertEquals("ceas", this.oneWordStem("cease"));
    }

    public void testStep5b() {
        TestTokenSequence2PorterStems.assertEquals("control", this.oneWordStem("controll"));
        TestTokenSequence2PorterStems.assertEquals("roll", this.oneWordStem("roll"));
    }

    private String oneWordStem(String str) {
        Instance instance = new Instance(str, null, null, null);
        InstanceList instances = new InstanceList(this.createPipes());
        instances.addThruPipe(instance);
        return this.tokenSequence2String((TokenSequence)instance.getData());
    }

    private String tokenSequence2String(TokenSequence tokenSequence) {
        StringBuilder builder = new StringBuilder();
        for (Token token : tokenSequence) {
            builder.append(token.getText()).append(' ');
        }
        return builder.toString().trim();
    }

    private SerialPipes createPipes() {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        pipes.add(new CharSequenceLowercase());
        pipes.add(new CharSequence2TokenSequence(CharSequenceLexer.LEX_WORDS));
        pipes.add(new TokenSequence2PorterStems());
        return new SerialPipes(pipes);
    }
}

