% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{is_force}
\alias{is_force}
\title{Opt-out Via Option}
\usage{
is_force(x = .packages()[1])
}
\arguments{
\item{x}{The option under which an element \code{"force"} is to be searched
for.}
}
\value{
\code{\link[base:TRUE]{TRUE}} if option \code{x[["force"]]} is either
\code{\link[base:TRUE]{TRUE}} or \code{\link[base:NULL]{NULL}} (i.e. not set
at all).
}
\description{
Check whether or not a package option (set via \code{\link{set_options}})
\emph{force} is not set or set to \code{\link[base:TRUE]{TRUE}}.
}
\examples{
is_force()
set_options(list(force = FALSE))
get_options(flatten_list = FALSE)
is_force()
}
\seealso{
Other option functions: 
\code{\link{get_options}()},
\code{\link{set_options}()}

Other logical helpers: 
\code{\link{get_run_r_tests}()},
\code{\link{is_batch}()},
\code{\link{is_cran}()},
\code{\link{is_false}()},
\code{\link{is_installed}()},
\code{\link{is_not_false}()},
\code{\link{is_null_or_true}()},
\code{\link{is_of_length_zero}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{is_success}()},
\code{\link{is_version_sufficient}()},
\code{\link{is_windows}()}
}
\concept{logical helpers}
\concept{option functions}
