/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DataFrame {
    private final ArrayList<String> columnNames = new ArrayList();
    private final ArrayList<Column> columns = new ArrayList();

    public int columns() {
        return this.columns.size();
    }

    public int rows() {
        return this.isEmpty() ? 0 : this.columns.get(0).size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean hasColumnHeader() {
        return this.columnNames.stream().anyMatch(Objects::nonNull);
    }

    public void addColumn(String name, Column column) {
        if (!this.isEmpty() && column.size() != this.rows()) {
            throw new IllegalArgumentException("Length of specified column does not match length of existing columns in the DataFrame!");
        }
        this.columnNames.add(name);
        this.columns.add(column);
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public DataType getColumnType(int index) {
        return this.columns.get(index).getDataType();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<DataType> getColumnTypes() {
        return this.columns.stream().map(Column::getDataType).collect(Collectors.toList());
    }
}

