/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;

public final class PackageRelationship {
    private static URI containerRelationshipPart;
    public static final String ID_ATTRIBUTE_NAME = "Id";
    public static final String RELATIONSHIPS_TAG_NAME = "Relationships";
    public static final String RELATIONSHIP_TAG_NAME = "Relationship";
    public static final String TARGET_ATTRIBUTE_NAME = "Target";
    public static final String TARGET_MODE_ATTRIBUTE_NAME = "TargetMode";
    public static final String TYPE_ATTRIBUTE_NAME = "Type";
    private final String id;
    private final OPCPackage container;
    private final String relationshipType;
    private final PackagePart source;
    private final TargetMode targetMode;
    private final URI targetUri;

    public PackageRelationship(OPCPackage pkg, PackagePart sourcePart, URI targetUri, TargetMode targetMode, String relationshipType, String id) {
        if (pkg == null) {
            throw new NullPointerException("pkg cannot be null");
        }
        if (targetUri == null) {
            throw new NullPointerException("targetUri cannot be null");
        }
        if (relationshipType == null) {
            throw new NullPointerException("relationshipType cannot be null");
        }
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.container = pkg;
        this.source = sourcePart;
        this.targetUri = targetUri;
        this.targetMode = targetMode;
        this.relationshipType = relationshipType;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageRelationship)) {
            return false;
        }
        PackageRelationship rel = (PackageRelationship)obj;
        return this.id.equals(rel.id) && this.relationshipType.equals(rel.relationshipType) && (rel.source == null || rel.source.equals(this.source)) && this.targetMode == rel.targetMode && this.targetUri.equals(rel.targetUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.relationshipType, this.source, this.targetMode, this.targetUri});
    }

    public static URI getContainerPartRelationship() {
        return containerRelationshipPart;
    }

    public OPCPackage getPackage() {
        return this.container;
    }

    public String getId() {
        return this.id;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public PackagePart getSource() {
        return this.source;
    }

    public URI getSourceURI() {
        if (this.source == null) {
            return PackagingURIHelper.PACKAGE_ROOT_URI;
        }
        return this.source._partName.getURI();
    }

    public TargetMode getTargetMode() {
        return this.targetMode;
    }

    public URI getTargetURI() {
        if (this.targetMode == TargetMode.EXTERNAL) {
            return this.targetUri;
        }
        if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(this.relationshipType)) {
            return this.targetUri;
        }
        if (!this.targetUri.toASCIIString().startsWith("/")) {
            return PackagingURIHelper.resolvePartUri(this.getSourceURI(), this.targetUri);
        }
        return this.targetUri;
    }

    public String toString() {
        return "id=" + this.id + " - container=" + this.container + " - relationshipType=" + this.relationshipType + (this.source == null ? " - source=null" : " - source=" + this.getSourceURI().toASCIIString()) + " - target=" + this.getTargetURI().toASCIIString() + (this.targetMode == null ? ",targetMode=null" : ",targetMode=" + (Object)((Object)this.targetMode));
    }

    static {
        try {
            containerRelationshipPart = new URI("/_rels/.rels");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

