/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.Basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KeelFile;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Randomize;

public class PrototypeSet
extends ArrayList<Prototype>
implements Comparable {
    protected InstanceSet associatedInstanceSet = null;

    public int compareTo(Object o1) {
        double valor2;
        double valor1 = this.size();
        if (valor1 < (valor2 = (double)((PrototypeSet)o1).size())) {
            return -1;
        }
        if (valor1 > valor2) {
            return 1;
        }
        return 0;
    }

    public PrototypeSet() {
    }

    public PrototypeSet(int numberOfElements) {
        super(numberOfElements);
    }

    public PrototypeSet(InstanceSet s) {
        super(new ArrayList(s.getNumInstances()));
        this.associatedInstanceSet = s;
        int num = s.getNumInstances();
        Instance[] instances = s.getInstances();
        for (int i = 0; i < num; ++i) {
            this.add(new Prototype(instances[i]));
        }
    }

    public PrototypeSet(ArrayList<PrototypeSet> parts) {
        super(parts.size());
        for (PrototypeSet ps : parts) {
            for (Prototype p : ps) {
                this.add(p);
            }
        }
    }

    public PrototypeSet isTheNearPrototype(Prototype other) {
        PrototypeSet result = new PrototypeSet();
        for (Prototype p : this) {
            Prototype near = this.nearestTo(p);
            if (!near.equals(other)) continue;
            result.add(p);
        }
        return result;
    }

    public PrototypeSet isTheNearPrototypeWithClass(Prototype other, double clase) {
        PrototypeSet result = new PrototypeSet();
        for (Prototype p : this) {
            Prototype near = this.nearestTo(p);
            if (!near.equals(other) || near.getOutput(0) != clase) continue;
            result.add(p);
        }
        return result;
    }

    public Prototype nearestTo(Prototype current) {
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        if (current == null) {
            return null;
        }
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (!(d < dMin) || current == p) continue;
            dMin = d;
            nearest = p;
        }
        return nearest;
    }

    public Prototype containing(Prototype current) {
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (!(d < dMin)) continue;
            dMin = d;
            nearest = p;
        }
        return nearest;
    }

    public int IndexNearestTo(Prototype current) {
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        int index = 0;
        int i = 0;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (d < dMin && current != p) {
                dMin = d;
                nearest = p;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int IndexSecondNearestTo(Prototype current) {
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        int index = 0;
        int i = 0;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (d < dMin && current != p) {
                dMin = d;
                nearest = p;
                index = i;
            }
            ++i;
        }
        dMin = Double.POSITIVE_INFINITY;
        i = 0;
        int index2 = 0;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (d < dMin && current != p && i != index) {
                dMin = d;
                nearest = p;
                index2 = i;
            }
            ++i;
        }
        return index2;
    }

    public Pair<Prototype, Double> minimumLengthAndNearestTo(Prototype current) {
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (!(d < dMin) || current == p) continue;
            dMin = d;
            nearest = p;
        }
        return new Pair<Object, Double>(nearest, dMin);
    }

    public Pair<Prototype, Double> minimumLengthAndNearestWithSameClassAs(Prototype current) {
        double currentLabel = current.label();
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (p.label() != currentLabel || !(d < dMin) || current == p) continue;
            dMin = d;
            nearest = p;
        }
        return new Pair<Object, Double>(nearest, dMin);
    }

    public Pair<Prototype, Prototype> nearestPair() {
        double dMin = Double.POSITIVE_INFINITY;
        Pair<Prototype, Prototype> nearest = null;
        for (Prototype p : this) {
            Pair<Prototype, Double> min = this.minimumLengthAndNearestWithSameClassAs(p);
            if (!(min.second() < dMin)) continue;
            dMin = min.second();
            nearest = new Pair<Prototype, Prototype>(p, min.first());
        }
        return nearest;
    }

    public Prototype nearestToWithClass(Prototype current, double label) {
        PrototypeSet set = this.getFromClass(label);
        double dMin = Double.POSITIVE_INFINITY;
        Prototype nearest = null;
        for (Prototype p : set) {
            double d = Distance.d(current, p);
            if (!(d < dMin)) continue;
            dMin = d;
            nearest = p;
        }
        return nearest;
    }

    public boolean uniqueAdd(Prototype newProt) {
        boolean found = false;
        int _size = this.size();
        for (int i = 0; !found && i < _size; ++i) {
            Prototype p = (Prototype)this.get(i);
            found = p == newProt || p.equals(newProt);
        }
        if (!found) {
            this.add(newProt);
        }
        return found;
    }

    public Prototype farthestTo(Prototype current) {
        double dMax = Double.NEGATIVE_INFINITY;
        Prototype farthest = null;
        for (Prototype p : this) {
            double d = Distance.d(current, p);
            if (!(d > dMax)) continue;
            dMax = d;
            farthest = p;
        }
        return farthest;
    }

    public PrototypeSet(PrototypeSet original) {
        super(original.size());
        this.associatedInstanceSet = original.associatedInstanceSet;
        for (Prototype p : original) {
            this.add(p);
        }
    }

    public Prototype getRandom() {
        return (Prototype)this.get(RandomGenerator.RandintClosed(0, this.size() - 1));
    }

    public Prototype removeRandom() {
        int i = RandomGenerator.RandintClosed(0, this.size() - 1);
        return (Prototype)this.remove(i);
    }

    public PrototypeSet getFromClass(double _class) {
        PrototypeSet selected = new PrototypeSet(this.size() / 2);
        for (Prototype p : this) {
            if (p.label() != _class) continue;
            selected.add(p);
        }
        return selected;
    }

    public PrototypeSet getAllDifferentFromClass(double _class) {
        PrototypeSet selected = new PrototypeSet(this.size() / 2);
        for (Prototype p : this) {
            if (p.label() == _class) continue;
            selected.add(p);
        }
        return selected;
    }

    public boolean containsSeveralClasses() {
        int _size = this.size();
        double label = ((Prototype)this.get(0)).label();
        boolean foundDifferent = false;
        for (int i = 1; i < _size && !foundDifferent; ++i) {
            foundDifferent = label != ((Prototype)this.get(i)).label();
        }
        return foundDifferent;
    }

    public HashMap<Double, Integer> countPrototypesOfEachOutput() {
        HashMap<Double, Integer> count = new HashMap<Double, Integer>();
        ArrayList<Double> values = Prototype.possibleValuesOfOutput();
        for (double d : values) {
            count.put(d, 0);
        }
        for (Prototype p : this) {
            count.put(p.firstOutput(), count.get(p.label()) + 1);
        }
        return count;
    }

    public HashMap<Double, Integer> getFrequencyOfClasses() {
        return this.countPrototypesOfEachOutput();
    }

    public ArrayList<Double> nonVoidClasses() {
        ArrayList<Double> nonVoidClasses = new ArrayList<Double>();
        ArrayList<Double> values = Prototype.possibleValuesOfOutput();
        HashMap<Double, Integer> freq = this.getFrequencyOfClasses();
        for (double c : values) {
            if (freq.get(c) <= 0) continue;
            nonVoidClasses.add(c);
        }
        return nonVoidClasses;
    }

    public ArrayList<Double> classesWithPrototypes() {
        return this.nonVoidClasses();
    }

    public double mostFrequentClass() {
        HashMap<Double, Integer> classes = this.getFrequencyOfClasses();
        int maxFreq = -1;
        double maxClass = -1.0;
        ArrayList<Double> array = new ArrayList<Double>(classes.keySet());
        for (double c : array) {
            int ocurr_c = classes.get(c);
            if (ocurr_c > maxFreq) {
                maxFreq = ocurr_c;
                maxClass = c;
                continue;
            }
            if (ocurr_c != maxFreq) continue;
            maxClass = RandomGenerator.randomSelector(c, maxClass);
        }
        return maxClass;
    }

    @Override
    public String toString() {
        String result = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            result = result + ((Prototype)this.get(i)).toString() + "\n";
        }
        return result;
    }

    public void print() {
        System.out.println("\n" + this.toString());
    }

    @Override
    public PrototypeSet clone() {
        PrototypeSet copy = new PrototypeSet(this.size());
        copy.associatedInstanceSet = this.associatedInstanceSet;
        for (Prototype p : this) {
            copy.add(new Prototype(p));
        }
        return copy;
    }

    public PrototypeSet copy() {
        return this.clone();
    }

    public HashSet<Prototype> toHashSet() {
        HashSet<Prototype> h = new HashSet<Prototype>();
        for (Prototype p : this) {
            h.add(p);
        }
        return h;
    }

    public HashMap<Prototype, Integer> toHashMap() {
        HashMap<Prototype, Integer> h = new HashMap<Prototype, Integer>();
        int _size = this.size();
        for (int i = 0; i < _size; ++i) {
            h.put((Prototype)this.get(i), i);
        }
        return h;
    }

    public PrototypeSet sort(Prototype current) {
        int _size = this.size();
        PrototypeSet sorted = new PrototypeSet(_size);
        sorted.add(this);
        Collections.sort(sorted, new Distance(current));
        return sorted;
    }

    public Pair<Prototype, Prototype> farthestPrototypes() {
        int _size = this.size();
        double maximumDistance = Double.NEGATIVE_INFINITY;
        Prototype ex1 = null;
        Prototype ex2 = null;
        for (int i = 0; i < _size; ++i) {
            for (int j = i + 1; j < _size; ++j) {
                Prototype p2;
                Prototype p1 = (Prototype)this.get(i);
                double cur_dist = Distance.d(p1, p2 = (Prototype)this.get(j));
                if (!(cur_dist > maximumDistance)) continue;
                maximumDistance = cur_dist;
                ex1 = p1;
                ex2 = p2;
            }
        }
        return new Pair<Object, Object>(ex1, ex2);
    }

    public Pair<PrototypeSet, PrototypeSet> partIntoSubsetsWhichSeedPointsAre(Prototype p1, Prototype p2) {
        return this.partIntoSubsetsWhichSeedPointsAre(new Pair<Prototype, Prototype>(p1, p2));
    }

    public Pair<PrototypeSet, PrototypeSet> partIntoSubsetsWhichSeedPointsAre(Pair<Prototype, Prototype> pair) {
        Prototype p1 = pair.first();
        Prototype p2 = pair.second();
        PrototypeSet P1 = new PrototypeSet();
        PrototypeSet P2 = new PrototypeSet();
        P1.add(p1);
        P2.add(p2);
        for (Prototype p : this) {
            if (p == p1 || p == p2) continue;
            if (Distance.d(p, p2) < Distance.d(p, p1)) {
                P2.add(p);
                continue;
            }
            P1.add(p);
        }
        Pair<PrototypeSet, PrototypeSet> part = new Pair<PrototypeSet, PrototypeSet>(P1, P2);
        return part;
    }

    public double Overlapping() {
        int ni;
        PrototypeSet aux;
        int i;
        double lapping = 0.0;
        double D1 = 0.0;
        double D2 = 0.0;
        Prototype m = new Prototype((Prototype)this.get(0));
        Prototype mi = new Prototype((Prototype)this.get(0));
        int numberOfClass = this.getPosibleValuesOfOutput().size();
        for (i = 0; i < numberOfClass; ++i) {
            aux = this.getFromClass(i);
            ni = aux.size();
            if (ni != 0) {
                m = this.avg();
                mi = aux.avg();
            }
            D1 += Distance.d(m.formatear(), mi.formatear()) * (double)ni;
        }
        for (i = 0; i < numberOfClass; ++i) {
            aux = this.getFromClass(i);
            ni = aux.size();
            if (ni != 0) {
                mi = aux.avg();
            }
            for (int j = 0; j < ni; ++j) {
                Prototype xij = (Prototype)aux.get(j);
                D2 += Distance.d(xij.formatear(), mi.formatear());
            }
        }
        lapping = D2 / D1;
        return lapping;
    }

    public boolean homogeneity() {
        return !this.containsSeveralClasses();
    }

    public Pair<PrototypeSet, PrototypeSet> partIntoSubsetsOverlappingDegree(Prototype p1, Prototype p2) {
        return this.partIntoSubsetsWhichSeedPointsAre(new Pair<Prototype, Prototype>(p1, p2));
    }

    public Pair<PrototypeSet, PrototypeSet> partIntoSubsetsOverlappingDegree(Pair<Prototype, Prototype> pair) {
        Prototype p1 = pair.first();
        Prototype p2 = pair.second();
        PrototypeSet P1 = new PrototypeSet();
        PrototypeSet P2 = new PrototypeSet();
        P1.add(p1);
        P2.add(p2);
        for (Prototype p : this) {
            if (p == p1 || p == p2) continue;
            if (Distance.d(p, p2) < Distance.d(p, p1)) {
                P2.add(p);
                continue;
            }
            P1.add(p);
        }
        Pair<PrototypeSet, PrototypeSet> part = new Pair<PrototypeSet, PrototypeSet>(P1, P2);
        return part;
    }

    public ArrayList<PrototypeSet> classPartition() {
        ArrayList<Double> classes = this.nonVoidClasses();
        ArrayList<PrototypeSet> part = new ArrayList<PrototypeSet>(classes.size());
        for (double c : classes) {
            PrototypeSet setC = this.getFromClass(c);
            if (setC.isEmpty()) continue;
            part.add(setC);
        }
        return part;
    }

    public void swap(int i1, int i2) {
        Collections.swap(this, i1, i2);
    }

    public void randomize() {
        Random r = new Random();
        r.setSeed(PrototypeGenerator.getSeed());
        Collections.shuffle(this, r);
    }

    public void randomize(long shuffleSeed) {
        Random r = new Random();
        r.setSeed(shuffleSeed);
        Collections.shuffle(this, r);
    }

    public Pair<PrototypeSet, PrototypeSet> makePartitionPerClass(double percentInFirst) {
        PrototypeSet first = new PrototypeSet();
        PrototypeSet second = new PrototypeSet();
        PrototypeSet copy = this.copy();
        ArrayList<Double> classes = copy.nonVoidClasses();
        for (double c : classes) {
            int i;
            PrototypeSet pc = copy.getFromClass(c);
            int pc_size = pc.size();
            int numInFirst = (int)Math.floor((double)pc_size * percentInFirst / 100.0);
            for (i = 0; i < numInFirst; ++i) {
                first.add(pc.get(i));
            }
            for (i = numInFirst; i < pc_size; ++i) {
                second.add(pc.get(i));
            }
        }
        return new Pair<PrototypeSet, PrototypeSet>(first, second);
    }

    public Pair<PrototypeSet, PrototypeSet> makePartition(double percentInFirst) {
        int i;
        PrototypeSet first = new PrototypeSet();
        PrototypeSet second = new PrototypeSet();
        PrototypeSet copy = this.copy();
        copy.randomize();
        int _size = this.size();
        int numInFirst = (int)Math.floor((double)_size * percentInFirst / 100.0);
        for (i = 0; i < numInFirst; ++i) {
            first.add(copy.get(i));
        }
        for (i = numInFirst; i < _size; ++i) {
            second.add(copy.get(i));
        }
        return new Pair<PrototypeSet, PrototypeSet>(first, second);
    }

    public ArrayList<PrototypeSet> partIn(int numberOfSets) {
        int _size = this.size();
        Debug.force(_size > numberOfSets, "Too much partitions");
        int _size_1 = _size - 1;
        int protsBySet = _size / numberOfSets;
        ArrayList<Integer> shuffle = RandomGenerator.generateDifferentRandomIntegers(0, _size_1, _size);
        ArrayList<PrototypeSet> partitions = new ArrayList<PrototypeSet>(numberOfSets);
        int offset = 0;
        for (int i = 0; i < numberOfSets; ++i) {
            PrototypeSet partition_i = new PrototypeSet();
            int end = offset + protsBySet;
            for (int index = offset; index < end; ++index) {
                int k = shuffle.get(index);
                partition_i.add(this.get(k));
            }
            partitions.add(partition_i);
            offset = end;
        }
        return partitions;
    }

    public double largestDiameter() {
        Pair<Prototype, Prototype> p = this.farthestPrototypes();
        return Distance.d(p.first(), p.second());
    }

    public String asKeelDataFileString(String title) {
        String line = "@relation " + title + "\n";
        Attribute[] attrs_input = Attributes.getInputAttributes();
        for (int i = 0; i < attrs_input.length; ++i) {
            line = line + attrs_input[i].toString() + "\n";
        }
        Attribute[] attrs_output = Attributes.getOutputAttributes();
        line = line + attrs_output[0].toString() + "\n";
        line = line + Attributes.getInputHeader() + "\n";
        String text = line = line + Attributes.getOutputHeader() + "\n";
        HashMap<Integer, Boolean> nominalInput = new HashMap<Integer, Boolean>();
        for (int i = 0; i < attrs_input.length; ++i) {
            nominalInput.put(i, Attributes.getInputAttribute(i).getType() == 0);
        }
        boolean nominal_output = Attributes.getOutputAttribute(0).getType() == 0;
        text = text + "@data\n";
        int n_attributes = ((Prototype)this.get(0)).numberOfInputs();
        for (Prototype p : this) {
            Prototype q = p.denormalize();
            for (int i = 0; i < n_attributes; ++i) {
                if (((Boolean)nominalInput.get(i)).booleanValue()) {
                    text = text + q.getInputAsNominal(i) + ", ";
                    continue;
                }
                double q_i = q.getInput(i);
                if (Prototype.getTypeOfAttribute(i) == 0) {
                    text = text + Math.round(q_i) + ", ";
                    continue;
                }
                if (Prototype.getTypeOfAttribute(i) != 1) continue;
                text = text + q_i + ", ";
            }
            if (nominal_output) {
                text = text + q.getOutputAsNominal(0) + "\n";
                continue;
            }
            text = text + q.label() + "\n";
        }
        return text;
    }

    public String asKeelDataFileString() {
        return this.asKeelDataFileString(Attributes.getRelationName());
    }

    public void save(String filename) {
        KeelFile.write(filename, this.asKeelDataFileString());
    }

    public PrototypeSet union(PrototypeSet other) {
        PrototypeSet result = new PrototypeSet(other.size() + this.size());
        for (Prototype p : this) {
            result.add(p);
        }
        for (Prototype p : other) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    public PrototypeSet join(Prototype other) {
        PrototypeSet result = this.copy();
        result.add(other);
        return result;
    }

    public PrototypeSet without(PrototypeSet other) {
        PrototypeSet result = new PrototypeSet(this);
        for (Prototype o : other) {
            if (!result.contains(o)) continue;
            result.remove(o);
        }
        return result;
    }

    public boolean remove(Prototype other) {
        boolean fin = false;
        for (int i = 0; i < this.size() && !fin; ++i) {
            if (!((Prototype)this.get(i)).equals(other)) continue;
            fin = true;
            this.remove(i);
        }
        return fin;
    }

    public boolean pertenece(Prototype other) {
        boolean fin = false;
        for (int i = 0; i < this.size() && !fin; ++i) {
            if (!((Prototype)this.get(i)).equals(other)) continue;
            fin = true;
        }
        return fin;
    }

    public PrototypeSet without(Prototype other) {
        PrototypeSet result = new PrototypeSet(this);
        if (result.contains(other)) {
            result.remove(other);
        } else {
            System.err.println("Error al borrase");
        }
        return result;
    }

    public PrototypeSet minus(PrototypeSet other) {
        return this.without(other);
    }

    public Prototype avg() {
        if (this.size() != 0) {
            int numInputs = ((Prototype)this.get(0)).numberOfInputs();
            int numOutputs = ((Prototype)this.get(0)).numberOfOutputs();
            double[] inputs = new double[numInputs];
            for (int i = 0; i < numInputs; ++i) {
                inputs[i] = 0.0;
            }
            double[] outputs = new double[numOutputs];
            for (int i = 0; i < numOutputs; ++i) {
                outputs[i] = ((Prototype)this.get(0)).getOutput(i);
            }
            for (Prototype p : this) {
                for (int i = 0; i < numInputs; ++i) {
                    int n = i;
                    inputs[n] = inputs[n] + p.getInput(i);
                }
            }
            int _size = this.size();
            int i = 0;
            while (i < numInputs) {
                int n = i++;
                inputs[n] = inputs[n] / (double)_size;
            }
            return new Prototype(inputs, outputs);
        }
        return null;
    }

    public Prototype sd() {
        int i;
        Prototype sd = new Prototype(((Prototype)this.get(0)).numberOfInputs(), 1);
        Prototype avg = this.avg();
        int N = this.size();
        Prototype Sumatory = new Prototype(((Prototype)this.get(0)).numberOfInputs(), 1);
        for (i = 0; i < Sumatory.numberOfInputs(); ++i) {
            Sumatory.setInput(i, 0.0);
        }
        for (i = 0; i < this.size(); ++i) {
            Prototype Xi = (Prototype)this.get(i);
            Prototype diference = Xi.sub(avg);
            diference = diference.mul(diference);
            for (int j = 0; j < Sumatory.numberOfInputs(); ++j) {
                Sumatory.setInput(j, Sumatory.getInput(j) + diference.getInput(j));
            }
        }
        for (int j = 0; j < Sumatory.numberOfInputs(); ++j) {
            Sumatory.setInput(j, Sumatory.getInput(j) / (double)N);
        }
        sd = Sumatory.sqrt();
        return sd;
    }

    public void add(PrototypeSet other) {
        for (Prototype p : other) {
            this.add(p);
        }
    }

    public void addPrototype(Prototype other) {
        this.add(other);
    }

    public PrototypeSet addPrototype2(Prototype other) {
        PrototypeSet otro = new PrototypeSet(this);
        otro.add(other);
        return otro;
    }

    public ArrayList<Double> getPosibleValuesOfOutput() {
        return Prototype.possibleValuesOfOutput();
    }

    public Pair<Prototype, Double> radius(Prototype center) {
        double max = -1.0;
        Prototype pMax = null;
        for (Prototype p : this) {
            double current = Distance.d(p, center);
            if (!(current > max)) continue;
            max = current;
            pMax = p;
        }
        return new Pair<Object, Double>(pMax, max);
    }

    public Pair<Prototype, Double> antiRadius(Prototype center) {
        double min = 9.99999999E8;
        Prototype pMin = null;
        for (Prototype p : this) {
            double current = Distance.d(p, center);
            if (!(current < min)) continue;
            min = current;
            pMin = p;
        }
        return new Pair<Object, Double>(pMin, min);
    }

    public double maxDistanceTo(Prototype center) {
        return this.radius(center).second();
    }

    public double minDistanceTo(Prototype center) {
        return this.antiRadius(center).second();
    }

    public double minDist(Prototype uno) {
        double min = 9.99999999E8;
        for (Prototype p : this) {
            double current = Distance.d(p, uno);
            if (!(current < min)) continue;
            min = current;
        }
        return min;
    }

    public static double variance(PrototypeSet ps, Prototype center) {
        double acc = 0.0;
        for (Prototype p : ps) {
            acc += Distance.d(center, p);
        }
        return acc;
    }

    public void applyThresholds() {
        for (Prototype p : this) {
            p.applyThresholds();
        }
    }

    public void printSet() {
        System.out.println("The prototype Set has " + this.size() + " instances");
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < ((Prototype)this.get(i)).numberOfInputs(); ++j) {
                System.out.print(((Prototype)this.get(i)).getInput(j) + " \t ");
            }
            System.out.print("\n");
        }
    }

    public int[] Cmeans(double[][] datosTrain, int C, double[][] centers) {
        double dist;
        double minDist;
        int j;
        int pos;
        int i;
        boolean cambio = true;
        int[] clusters = new int[datosTrain.length];
        int[] baraje = new int[datosTrain.length];
        for (i = 0; i < datosTrain.length; ++i) {
            baraje[i] = i;
        }
        for (i = 0; i < datosTrain.length; ++i) {
            pos = Randomize.Randint(i, datosTrain.length);
            int tmp = baraje[i];
            baraje[i] = baraje[pos];
            baraje[pos] = tmp;
        }
        for (i = 0; i < C; ++i) {
            for (j = 0; j < datosTrain[0].length; ++j) {
                centers[i][j] = datosTrain[baraje[i]][j];
            }
        }
        for (i = 0; i < datosTrain.length; ++i) {
            pos = 0;
            minDist = KNN.distancia((double[])datosTrain[i], (double[])centers[0]);
            for (j = 1; j < C; ++j) {
                dist = KNN.distancia((double[])datosTrain[i], (double[])centers[j]);
                if (!(dist < minDist)) continue;
                pos = j;
                minDist = dist;
            }
            clusters[i] = pos;
        }
        int[] nc = new int[C];
        while (cambio) {
            cambio = false;
            Arrays.fill(nc, 0);
            for (i = 0; i < C; ++i) {
                Arrays.fill(centers[i], 0.0);
            }
            for (i = 0; i < datosTrain.length; ++i) {
                int n = clusters[i];
                nc[n] = nc[n] + 1;
                for (j = 0; j < datosTrain[0].length; ++j) {
                    double[] dArray = centers[clusters[i]];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + datosTrain[i][j];
                }
            }
            for (i = 0; i < C; ++i) {
                j = 0;
                while (j < datosTrain[0].length) {
                    double[] dArray = centers[i];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)nc[i];
                }
            }
            for (i = 0; i < datosTrain.length; ++i) {
                pos = 0;
                minDist = KNN.distancia((double[])datosTrain[i], (double[])centers[0]);
                for (j = 1; j < C; ++j) {
                    dist = KNN.distancia((double[])datosTrain[i], (double[])centers[j]);
                    if (!(dist < minDist)) continue;
                    pos = j;
                    minDist = dist;
                }
                if (clusters[i] == pos) continue;
                cambio = true;
                clusters[i] = pos;
            }
        }
        return clusters;
    }

    public void doubleToprototypeSet(double[][] datos, int[] clase) {
        new PrototypeSet();
        for (int i = 0; i < datos.length; ++i) {
            if (Double.isNaN(datos[i][0])) continue;
            Prototype o = new Prototype(datos[i].length, 1);
            for (int j = 0; j < datos[i].length; ++j) {
                o.setInput(j, datos[i][j]);
            }
            o.setFirstOutput(clase[i]);
            this.add(o);
        }
    }

    public double[][] prototypeSetTodouble() {
        double[][] datos = new double[this.size()][];
        for (int i = 0; i < this.size(); ++i) {
            datos[i] = new double[((Prototype)this.get(0)).numberOfInputs()];
            datos[i] = ((Prototype)this.get(i)).getInputs();
        }
        return datos;
    }

    public int[] getClases() {
        int[] datos = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            datos[i] = (int)((Prototype)this.get(i)).getOutput(0);
        }
        return datos;
    }

    public void doubleToprototypeSet(double[][] datos, int clase) {
        new PrototypeSet();
        for (int i = 0; i < datos.length; ++i) {
            if (Double.isNaN(datos[i][0])) continue;
            Prototype o = new Prototype(datos[i].length, 1);
            for (int j = 0; j < datos[i].length; ++j) {
                o.setInput(j, datos[i][j]);
            }
            o.setFirstOutput(clase);
            this.add(o);
        }
    }

    public PrototypeSet sumar(PrototypeSet other) {
        PrototypeSet suma = new PrototypeSet();
        if (this.size() == other.size()) {
            for (int i = 0; i < this.size(); ++i) {
                suma.add(((Prototype)this.get(i)).add((Prototype)other.get(i)));
            }
        } else {
            return null;
        }
        return suma;
    }

    public PrototypeSet restar(PrototypeSet other) {
        PrototypeSet resta = new PrototypeSet();
        if (this.size() == other.size()) {
            for (int i = 0; i < this.size(); ++i) {
                resta.add(((Prototype)this.get(i)).sub((Prototype)other.get(i)));
            }
        } else {
            return null;
        }
        return resta;
    }

    public PrototypeSet mulEscalar(double escalar) {
        PrototypeSet result = new PrototypeSet();
        for (int i = 0; i < this.size(); ++i) {
            result.add(((Prototype)this.get(i)).mul(escalar));
        }
        return result;
    }

    public PrototypeSet opposite() {
        PrototypeSet opuesto = new PrototypeSet();
        for (int i = 0; i < this.size(); ++i) {
            opuesto.add(((Prototype)this.get(i)).opposite());
        }
        return opuesto;
    }

    public String[][] toBinaryString() {
        String[][] datos = new String[this.size()][];
        double parametroConversion = 0.00392156862745098;
        for (int i = 0; i < this.size(); ++i) {
            datos[i] = new String[((Prototype)this.get(0)).numberOfInputs()];
            for (int j = 0; j < ((Prototype)this.get(i)).numberOfInputs(); ++j) {
                double number = ((Prototype)this.get(i)).getInput(j);
                if (number < 0.0) {
                    number = 0.0;
                } else if (number > 1.0) {
                    number = 1.0;
                }
                Integer num = (int)(number / parametroConversion);
                String aux = Integer.toBinaryString(num);
                while (aux.length() < 8) {
                    aux = "0" + aux;
                }
                datos[i][j] = new String();
                datos[i][j] = aux;
            }
        }
        return datos;
    }

    public String[][] to8GrayString() {
        String[][] datos = new String[this.size()][];
        double parametroConversion = 0.00392156862745098;
        for (int i = 0; i < this.size(); ++i) {
            datos[i] = new String[((Prototype)this.get(0)).numberOfInputs()];
            for (int j = 0; j < ((Prototype)this.get(i)).numberOfInputs(); ++j) {
                int m;
                double number = ((Prototype)this.get(i)).getInput(j);
                if (number < 0.0) {
                    number = 0.0;
                } else if (number > 1.0) {
                    number = 1.0;
                }
                Integer num = (int)(number / parametroConversion);
                String aux = Integer.toBinaryString(num);
                while (aux.length() < 8) {
                    aux = "0" + aux;
                }
                String[] gray = aux.split("");
                for (m = gray.length - 1; m > 1; --m) {
                    if (Integer.parseInt(gray[m - 1]) != 1) continue;
                    gray[m] = Integer.toString(1 - Integer.parseInt(gray[m]));
                }
                aux = "";
                for (m = 0; m < gray.length; ++m) {
                    aux = aux + gray[m];
                }
                datos[i][j] = new String();
                datos[i][j] = aux;
            }
        }
        return datos;
    }

    public void toPrototypeSet(String[][] datos, double[] clases) {
        double parametroConversion = 0.00392156862745098;
        new PrototypeSet(datos.length);
        for (int i = 0; i < datos.length; ++i) {
            Prototype aux = new Prototype(datos[0].length, 1);
            for (int j = 0; j < datos[i].length; ++j) {
                int k;
                int num = 0;
                String aux2 = "";
                aux2 = aux2 + datos[i][j].charAt(0);
                for (k = 1; k < 8; ++k) {
                    char uno = aux2.charAt(k - 1);
                    char dos = datos[i][j].charAt(k);
                    aux2 = uno == '0' && dos == '0' ? aux2 + "0" : (uno == '1' && dos == '1' ? aux2 + "0" : aux2 + "1");
                }
                for (k = 0; k < 8; ++k) {
                    int bit = Character.getNumericValue(aux2.charAt(k));
                    num = (int)((double)num + Math.pow(2.0, 7 - k) * (double)bit);
                }
                double valor = (double)num * parametroConversion;
                aux.setInput(j, valor);
            }
            this.add(aux);
            ((Prototype)this.get(i)).setFirstOutput(clases[i]);
        }
    }

    public void formatear(PrototypeSet initial) {
        new PrototypeSet();
        for (int i = 0; i < initial.size(); ++i) {
            this.add(((Prototype)initial.get(i)).formatear());
        }
    }

    public static PrototypeSet selecRandomSet(PrototypeSet original, int numberOfPrototypesSelected, boolean usePriorProb) {
        if (usePriorProb && numberOfPrototypesSelected != original.size()) {
            int numberOfInstances_1 = original.size() - 1;
            int _size = original.size();
            double prop = (double)numberOfPrototypesSelected / (double)_size;
            PrototypeSet edited = new PrototypeSet();
            HashMap<Double, Integer> sizeOfPartition = original.countPrototypesOfEachOutput();
            ArrayList<Double> values = Prototype.possibleValuesOfOutput();
            for (double class_i : values) {
                int n_class_i = (int)Math.floor(prop * (double)sizeOfPartition.get(class_i).intValue());
                HashSet<Integer> forbidden = new HashSet<Integer>();
                for (int k = 0; k < n_class_i; ++k) {
                    int chosen;
                    while (forbidden.contains(chosen = RandomGenerator.Randint(0, numberOfInstances_1)) || ((Prototype)original.get(chosen)).firstOutput() != class_i) {
                    }
                    forbidden.add(chosen);
                    edited.add(original.get(chosen));
                }
            }
            HashSet<Integer> forbidden = new HashSet<Integer>();
            while (edited.size() < numberOfPrototypesSelected) {
                int chosen;
                while (forbidden.contains(chosen = RandomGenerator.Randint(0, numberOfInstances_1)) || edited.contains(original.get(chosen))) {
                }
                forbidden.add(chosen);
                edited.add(original.get(chosen));
            }
            return edited;
        }
        PrototypeSet edited = new PrototypeSet(numberOfPrototypesSelected);
        RandomGenerator.generateDifferentRandomIntegers(0, original.size());
        ArrayList<Integer> indexes = RandomGenerator.generateDifferentRandomIntegers(0, original.size() - 1);
        for (int i = 0; i < numberOfPrototypesSelected; ++i) {
            edited.add(original.get(indexes.get(i)));
        }
        return edited;
    }
}

