/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import java.util.Enumeration;
import java.util.Vector;

public class MyAttribute {
    public static final int CONTINUOUS = 0;
    public static final int DISCRET = 1;
    private String name;
    private int type;
    private Vector values;
    private float bottom;
    private float top;
    private int index;
    private boolean used;

    public MyAttribute(String attributeName, int attributeIndex) {
        this.name = attributeName;
        this.index = attributeIndex;
        this.values = null;
        this.type = 0;
        this.used = false;
    }

    public MyAttribute(String attributeName, Vector attributeValues, int attributeIndex) {
        this.name = attributeName;
        this.index = attributeIndex;
        this.type = 1;
        this.values = new Vector(attributeValues.size());
        this.used = false;
        for (int i = 0; i < attributeValues.size(); ++i) {
            Object store = attributeValues.elementAt(i);
            this.values.addElement(store);
        }
    }

    public final int valueIndex(String value) {
        int i = 0;
        if (!this.isDiscret()) {
            return -1;
        }
        Enumeration enum2 = this.values.elements();
        while (enum2.hasMoreElements()) {
            String element = (String)enum2.nextElement();
            if (element.equalsIgnoreCase(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean isDiscret() {
        return this.type == 1;
    }

    public final boolean isContinuous() {
        return this.type == 0;
    }

    public final String name() {
        return this.name;
    }

    public final int numValues() {
        if (!this.isDiscret()) {
            return 0;
        }
        return this.values.size();
    }

    public final String value(int valIndex) {
        if (!this.isDiscret()) {
            return "";
        }
        Object val = this.values.elementAt(valIndex);
        return (String)val;
    }

    final void setRange(float minRange, float maxRange) {
        if (this.isDiscret()) {
            throw new IllegalArgumentException("Can only set value of numeric attribute!");
        }
        this.bottom = minRange;
        this.top = maxRange;
    }

    final void setRange(int minRange, int maxRange) {
        if (this.isDiscret()) {
            throw new IllegalArgumentException("Can only set value of numeric attribute!");
        }
        this.bottom = minRange;
        this.top = maxRange;
    }

    public final float getMinRange() {
        if (this.isDiscret()) {
            throw new IllegalArgumentException("Can only set value of numeric attribute!");
        }
        return this.bottom;
    }

    public final float getMaxRange() {
        if (this.isDiscret()) {
            throw new IllegalArgumentException("Can only set value of numeric attribute!");
        }
        return this.top;
    }

    public void activate() {
        this.used = true;
    }

    public boolean isActive() {
        return this.used;
    }
}

