/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.iap.ResponseInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class Protocol {
    protected String host;
    private Socket socket;
    protected boolean debug;
    protected boolean quote;
    protected PrintStream out;
    private TraceInputStream traceInput;
    private ResponseInputStream input;
    private TraceOutputStream traceOutput;
    private DataOutputStream output;
    private int tagCounter = 0;
    private Vector handlers = null;
    private long timestamp;
    protected static final byte[] CRLF = new byte[]{13, 10};

    public Protocol(String host, int port, boolean debug, PrintStream out, Properties props, String prefix, boolean isSSL) throws IOException, ProtocolException {
        this.host = host;
        this.debug = debug;
        this.out = out;
        this.socket = SocketFetcher.getSocket(host, port, props, prefix, isSSL);
        String s = props.getProperty("mail.debug.quote");
        this.quote = s != null && s.equalsIgnoreCase("true");
        this.initStreams(out);
        this.processGreeting(this.readResponse());
        this.timestamp = System.currentTimeMillis();
    }

    private void initStreams(PrintStream out) throws IOException {
        this.traceInput = new TraceInputStream(this.socket.getInputStream(), out);
        this.traceInput.setTrace(this.debug);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream(this.traceInput);
        this.traceOutput = new TraceOutputStream(this.socket.getOutputStream(), out);
        this.traceOutput.setTrace(this.debug);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream(this.traceOutput));
    }

    public Protocol(InputStream in, OutputStream out, boolean debug) throws IOException {
        this.host = "localhost";
        this.debug = debug;
        this.quote = false;
        this.out = System.out;
        this.traceInput = new TraceInputStream(in, System.out);
        this.traceInput.setTrace(debug);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream(this.traceInput);
        this.traceOutput = new TraceOutputStream(out, System.out);
        this.traceOutput.setTrace(debug);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream(this.traceOutput));
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void addResponseHandler(ResponseHandler h) {
        if (this.handlers == null) {
            this.handlers = new Vector();
        }
        this.handlers.addElement(h);
    }

    public synchronized void removeResponseHandler(ResponseHandler h) {
        if (this.handlers != null) {
            this.handlers.removeElement(h);
        }
    }

    public void notifyResponseHandlers(Response[] responses) {
        if (this.handlers == null) {
            return;
        }
        for (int i = 0; i < responses.length; ++i) {
            Response r = responses[i];
            if (r == null) continue;
            int size2 = this.handlers.size();
            if (size2 == 0) {
                return;
            }
            Object[] h = new Object[size2];
            this.handlers.copyInto(h);
            for (int j = 0; j < size2; ++j) {
                ((ResponseHandler)h[j]).handleResponse(r);
            }
        }
    }

    protected void processGreeting(Response r) throws ProtocolException {
        if (r.isBYE()) {
            throw new ConnectionException(this, r);
        }
    }

    protected ResponseInputStream getInputStream() {
        return this.input;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected boolean supportsNonSyncLiterals() {
        return false;
    }

    public Response readResponse() throws IOException, ProtocolException {
        return new Response(this);
    }

    public String writeCommand(String command, Argument args) throws IOException, ProtocolException {
        String tag = "A" + Integer.toString(this.tagCounter++, 10);
        this.output.writeBytes(tag + " " + command);
        if (args != null) {
            this.output.write(32);
            args.write(this);
        }
        this.output.write(CRLF);
        this.output.flush();
        return tag;
    }

    public synchronized Response[] command(String command, Argument args) {
        Vector<Response> v = new Vector<Response>();
        boolean done = false;
        String tag = null;
        Response r = null;
        try {
            tag = this.writeCommand(command, args);
        }
        catch (LiteralException lex) {
            v.addElement(lex.getResponse());
            done = true;
        }
        catch (Exception ex) {
            v.addElement(Response.byeResponse(ex));
            done = true;
        }
        while (!done) {
            try {
                r = this.readResponse();
            }
            catch (IOException ioex) {
                r = Response.byeResponse(ioex);
            }
            catch (ProtocolException pex) {
                continue;
            }
            v.addElement(r);
            if (r.isBYE()) {
                done = true;
            }
            if (!r.isTagged() || !r.getTag().equals(tag)) continue;
            done = true;
        }
        Object[] responses = new Response[v.size()];
        v.copyInto(responses);
        this.timestamp = System.currentTimeMillis();
        return responses;
    }

    public void handleResult(Response response) throws ProtocolException {
        if (response.isOK()) {
            return;
        }
        if (response.isNO()) {
            throw new CommandFailedException(response);
        }
        if (response.isBAD()) {
            throw new BadCommandException(response);
        }
        if (response.isBYE()) {
            this.disconnect();
            throw new ConnectionException(this, response);
        }
    }

    public void simpleCommand(String cmd, Argument args) throws ProtocolException {
        Response[] r = this.command(cmd, args);
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
    }

    public void startTLS(String cmd) throws IOException, ProtocolException {
        this.simpleCommand(cmd, null);
        this.socket = SocketFetcher.startTLS(this.socket);
        this.initStreams(this.out);
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }
}

