/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ReifiedBinImplication
extends AbstractTernIntSConstraint {
    public ReifiedBinImplication(IntDomainVar b, IntDomainVar v1, IntDomainVar v2) {
        super(b, v1, v2);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    private boolean updateOnV0(int val) throws ContradictionException {
        boolean mod = false;
        if (val == 0) {
            mod |= this.v1.instantiate(1, this, false);
            mod |= this.v2.instantiate(0, this, false);
        } else if (this.v1.isInstantiatedTo(0)) {
            this.setEntailed();
        } else if (this.v1.isInstantiatedTo(1)) {
            mod |= this.v2.instantiate(1, this, false);
        }
        return mod;
    }

    private void updateOnV1(int val) throws ContradictionException {
        if (val == 0) {
            this.v0.instantiate(1, this, false);
        } else if (this.v0.isInstantiated()) {
            this.v2.instantiate(this.v0.getVal(), this, false);
        } else if (this.v2.isInstantiated()) {
            this.v0.instantiate(this.v2.getVal(), this, false);
        }
    }

    private void updateOnV2(int val) throws ContradictionException {
        if (val == 0) {
            if (this.v0.isInstantiated()) {
                this.v1.instantiate(Math.abs(this.v0.getVal() - 1), this, false);
            } else if (this.v1.isInstantiated()) {
                this.v0.instantiate(Math.abs(this.v1.getVal() - 1), this, false);
            }
        } else {
            this.v0.instantiate(1, this, false);
            this.setEntailed();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.updateOnV0(this.v0.getVal());
        }
        if (this.v1.isInstantiated()) {
            this.updateOnV1(this.v1.getVal());
        }
        if (this.v2.isInstantiated()) {
            this.updateOnV2(this.v2.getVal());
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        switch (idx) {
            case 0: {
                this.updateOnV0(this.v0.getVal());
                break;
            }
            case 1: {
                this.updateOnV1(this.v1.getVal());
                break;
            }
            case 2: {
                this.updateOnV2(this.v2.getVal());
            }
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        if (tuple[0] == 0) {
            return tuple[1] == 1 && tuple[2] == 0;
        }
        return tuple[1] <= tuple[2];
    }

    @Override
    public Boolean isEntailed() {
        return null;
    }
}

