## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(dematel)

## -----------------------------------------------------------------------------
my_data = dematel::medicaldevice

my_data

## -----------------------------------------------------------------------------
normalize_data(my_data, data_control = F)

## -----------------------------------------------------------------------------
normalize_data(my_data, data_control = T)

## -----------------------------------------------------------------------------
total_relationship_matrix(my_data, data_control = T)

## -----------------------------------------------------------------------------
total_relationship_matrix(my_data)

## -----------------------------------------------------------------------------
relationships_between_criteria(my_data, data_control = T)

## -----------------------------------------------------------------------------
visualize(my_data)

## -----------------------------------------------------------------------------
threshold_value(my_data)

## -----------------------------------------------------------------------------
compare_criteria(my_data)

## -----------------------------------------------------------------------------
execute_dematel(my_data)

