/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

class DelegateDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateDoubleMatrix2D(DoubleMatrix3D doubleMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= doubleMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(doubleMatrix3D.rows(), doubleMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= doubleMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(doubleMatrix3D.slices(), doubleMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= doubleMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(doubleMatrix3D.slices(), doubleMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = doubleMatrix3D;
    }

    public synchronized double getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public DoubleMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, double d) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, d);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, d);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, d);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public DoubleMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperDoubleMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public DoubleMatrix1D like1D(int n) {
        throw new InternalError();
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseDoubleMatrix1D;
    }
}

