/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.BackboneNodeFilter;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class FixedDriftModel
extends AbstractBranchRateModel {
    private TreeModel treeModel;
    private Parameter backboneDrift;
    private Parameter otherDrift;
    private BackboneNodeFilter backbone;

    public FixedDriftModel(TreeModel treeModel, Parameter parameter, Parameter parameter2, TaxonList taxonList) {
        super("fixedDriftModel");
        this.backboneDrift = parameter;
        this.addVariable(parameter);
        this.otherDrift = parameter2;
        this.addVariable(parameter2);
        this.backbone = new BackboneNodeFilter("backbone", treeModel, taxonList, true, true);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.backbone.computeBackBoneMap();
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (this.backbone.includeNode(tree, nodeRef)) {
            return this.backboneDrift.getParameterValue(0);
        }
        return this.otherDrift.getParameterValue(0);
    }
}

