/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.EuclideanDivisionXYZ;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class DivNode
extends INode
implements ArithmNode {
    public DivNode(INode[] subt) {
        super(subt, NodeType.DIV);
    }

    @Override
    public int eval(int[] tuple) {
        int r1 = ((ArithmNode)((Object)this.subtrees[1])).eval(tuple);
        if (r1 == 0) {
            return Integer.MAX_VALUE;
        }
        return ((ArithmNode)((Object)this.subtrees[0])).eval(tuple) / r1;
    }

    @Override
    public boolean isDecompositionPossible() {
        return false;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = this.subtrees[1].extractResult(s);
        int lb = Math.min(v1.getInf(), v2.getInf());
        int ub = Math.max(v1.getSup(), v2.getSup());
        IntDomainVar v3 = lb == 0 && ub == 1 ? s.createBooleanVar(StringUtils.randomName()) : (v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain() ? s.createEnumIntVar(StringUtils.randomName(), lb, ub) : s.createBoundIntVar(StringUtils.randomName(), lb, ub));
        s.post(new EuclideanDivisionXYZ(v1, v2, v3));
        return v3;
    }

    @Override
    public String pretty() {
        return "(" + this.subtrees[0].pretty() + " / " + this.subtrees[1].pretty() + ")";
    }
}

