/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching.domwdeg;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Iterator;

public class DomWDegUtils {
    private static final int ABSTRACTCONTRAINT_EXTENSION = AbstractSConstraint.getAbstractSConstraintExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");
    private static final int ABSTRACTVAR_EXTENSION = AbstractVar.getAbstractVarExtensionNumber("choco.cp.cpsolver.search.integer.varselector.DomOverWDeg");

    private DomWDegUtils() {
    }

    public static void addConstraintExtension(SConstraint<?> c) {
        c.addExtension(ABSTRACTCONTRAINT_EXTENSION);
    }

    public static void addVariableExtension(Var v) {
        v.addExtension(ABSTRACTVAR_EXTENSION);
    }

    public static Extension getConstraintExtension(SConstraint<?> c) {
        return c.getExtension(ABSTRACTCONTRAINT_EXTENSION);
    }

    public static Extension getVarExtension(Var v) {
        return v.getExtension(ABSTRACTVAR_EXTENSION);
    }

    public static int getFineDegree(Var v, SConstraint<?> c, int cIdx) {
        return c.getFineDegree(v.getVarIndex(cIdx));
    }

    public static void initConstraintExtensions(Solver s) {
        DisposableIterator<SConstraint> iter = s.getConstraintIterator();
        while (iter.hasNext()) {
            DomWDegUtils.addConstraintExtension((SConstraint)iter.next());
        }
        iter.dispose();
    }

    public static void initVarExtensions(Solver s) {
        DisposableIterator<IntDomainVar> iter = s.getIntVarIterator();
        while (iter.hasNext()) {
            DomWDegUtils.addVariableExtension((Var)iter.next());
        }
        iter.dispose();
        Iterator<Integer> it = s.getIntConstantSet().iterator();
        while (it.hasNext()) {
            DomWDegUtils.addVariableExtension(s.getIntConstant(it.next()));
        }
    }

    public static boolean hasAtLeastTwoNotInstVars(SConstraint<?> c) {
        int n = c.getNbVars();
        boolean hasNotInst = false;
        for (int i = 0; i < n; ++i) {
            if (c.getVarQuick(i).isInstantiated()) continue;
            if (hasNotInst) {
                return true;
            }
            hasNotInst = true;
        }
        return false;
    }

    protected static boolean hasTwoNotInstVars(SConstraint<?> c) {
        int n = c.getNbVars();
        int cpt = -2;
        for (int i = 0; i < n; ++i) {
            if (c.getVarQuick(i).isInstantiated() || ++cpt <= 0) continue;
            return false;
        }
        return cpt == 0;
    }

    public static final int computeWeightedDegreeFromScratch(Var var) {
        int weight = 0;
        DisposableIntIterator iter = var.getIndexVector().getIndexIterator();
        while (iter.hasNext()) {
            int idx = iter.next();
            SConstraint c = var.getConstraint(idx);
            if (!SConstraintType.INTEGER.isTypeOf(c) || !DomWDegUtils.hasAtLeastTwoNotInstVars(c)) continue;
            try {
                weight += DomWDegUtils.getConstraintExtension(c).get() + DomWDegUtils.getFineDegree(var, c, idx);
            }
            catch (NullPointerException npe) {
                DomWDegUtils.addConstraintExtension(c);
                weight += DomWDegUtils.getConstraintExtension(c).get() + DomWDegUtils.getFineDegree(var, c, idx);
            }
        }
        iter.dispose();
        return weight;
    }

    public static void addFailure(SConstraint<?> cause) {
        if (cause != null && SConstraintType.INTEGER.isTypeOf(cause)) {
            try {
                DomWDegUtils.getConstraintExtension(cause).add(1);
            }
            catch (NullPointerException npe) {
                DomWDegUtils.addConstraintExtension(cause);
                DomWDegUtils.getConstraintExtension(cause).add(1);
            }
        }
    }

    public static void addConstraintToVarWeights(SConstraint<?> c) {
        int nbF = DomWDegUtils.getConstraintExtension(c).get();
        int n = c.getNbVars();
        for (int k = 0; k < n; ++k) {
            if (DomWDegUtils.getVarExtension(c.getVarQuick(k)) == null) {
                DomWDegUtils.addVariableExtension(c.getVarQuick(k));
            }
            DomWDegUtils.getVarExtension(c.getVarQuick(k)).add(c.getFineDegree(k) + nbF);
        }
    }

    public static void addIncFailure(SConstraint<?> cause) {
        if (cause != null && SConstraintType.INTEGER.isTypeOf(cause)) {
            try {
                DomWDegUtils.getConstraintExtension(cause).add(1);
                int n = cause.getNbVars();
                for (int k = 0; k < n; ++k) {
                    DomWDegUtils.getVarExtension(cause.getVarQuick(k)).add(1);
                }
            }
            catch (NullPointerException npe) {
                DomWDegUtils.addConstraintExtension(cause);
                DomWDegUtils.getConstraintExtension(cause).add(1);
                DomWDegUtils.addConstraintToVarWeights(cause);
            }
        }
    }

    public static final String getConstraintFailures(Solver solver) {
        StringBuilder b = new StringBuilder();
        DisposableIterator<SConstraint> iter = solver.getConstraintIterator();
        while (iter.hasNext()) {
            SConstraint cstr = (SConstraint)iter.next();
            b.append("failures=").append(DomWDegUtils.getConstraintExtension(cstr).get());
            b.append("\t").append(cstr.pretty());
            b.append('\n');
        }
        iter.dispose();
        return new String(b);
    }

    public static final String getVariableWDeg(Solver solver) {
        StringBuilder b = new StringBuilder();
        DisposableIterator<IntDomainVar> iter = solver.getIntVarIterator();
        while (iter.hasNext()) {
            IntDomainVar v = (IntDomainVar)iter.next();
            b.append("wdeg=").append(DomWDegUtils.computeWeightedDegreeFromScratch(v));
            b.append("\t").append(v.pretty());
            b.append('\n');
        }
        iter.dispose();
        return new String(b);
    }

    public static final String checkVariableIncWDeg(Solver solver) {
        StringBuilder b = new StringBuilder();
        DisposableIterator<IntDomainVar> iter = solver.getIntVarIterator();
        while (iter.hasNext()) {
            int w2;
            IntDomainVar v = (IntDomainVar)iter.next();
            int w1 = DomWDegUtils.computeWeightedDegreeFromScratch(v);
            if (w1 == (w2 = DomWDegUtils.getVarExtension(v).get())) continue;
            b.append("wdeg=").append(w2).append(" vs ").append(w1);
            b.append("\t").append(v.pretty());
            b.append('\n');
        }
        iter.dispose();
        return new String(b);
    }

    public static final String getVariableIncWDeg(Solver solver) {
        StringBuilder b = new StringBuilder();
        DisposableIterator<IntDomainVar> iter = solver.getIntVarIterator();
        while (iter.hasNext()) {
            IntDomainVar v = (IntDomainVar)iter.next();
            b.append("wdeg=").append(DomWDegUtils.getVarExtension(v).get());
            b.append("\t").append(v.pretty());
            b.append('\n');
        }
        iter.dispose();
        return new String(b);
    }
}

