## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  fig.width = 10, # Set default plot width (adjust as needed)
  fig.height = 8, # Set default plot height (adjust as needed)
  fig.align = "center" # Center align all plots
)

# knitr::opts_chunk$set(eval = FALSE)

## -----------------------------------------------------------------------------
library(gmwmx2)

## -----------------------------------------------------------------------------
station_data <- download_station_ngl("CHML")

## -----------------------------------------------------------------------------
plot(station_data)

## -----------------------------------------------------------------------------
plot(station_data, component = "N")

## -----------------------------------------------------------------------------
fit1 <- gmwmx2(station_data, n_seasonal = 2, component = "N", stochastic_model = "wn + pl")

## -----------------------------------------------------------------------------
summary(fit1)

## -----------------------------------------------------------------------------
summary(fit1, scale_parameters = TRUE)

## -----------------------------------------------------------------------------
plot(fit1)

## -----------------------------------------------------------------------------
fit2 <- gmwmx2(station_data, n_seasonal = 2, component = "N", stochastic_model = "wn + fl")

## -----------------------------------------------------------------------------
summary(fit2)

## -----------------------------------------------------------------------------
plot(fit2)

