## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(tidy = FALSE)

## ----echo = FALSE-------------------------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("r_times")

r_times

## -----------------------------------------------------------------------------
bin_res <- 10 # Lower values will create a higher resolution distribution and vice-versa.
min_x <- 0 # We use 0 as a starting point in order to get a distribution for the complete duration of the trail.
max_x <- 180 # In this specific example the total trail duration was 3 minutes.
binarized_data <- get_bins(r_times, min_x, max_x, bin_res)
data_ftable <- f_table(binarized_data, min_x, max_x, bin_res)

data_ftable

## ----echo = FALSE-------------------------------------------------------------
plot(data_ftable$bins, data_ftable$prop,
  xlab = "Time bins",
  ylab = "Response proportion",
  pch = 21,
  bg = "black"
)

