/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class NTFJMSConnectionGroup {
    ArrayList<NTFJMSConnection> jmsListenerConnections = new ArrayList();
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private int noOfRegistrationsInThisGroup = 0;
    String uniqueIdentifier;
    static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS = 0;
    private int aliveConnections = 0;
    private HashMap<Long, NTFJMSRegistration> jmsRegIdToNtfReg = new HashMap();

    public static synchronized void setMaxNtfConnection(int n2) {
        if (n2 <= 0) {
            n2 = 16;
        }
        if (MAX_NTF_CONNECTIONS > 0) {
            return;
        }
        MAX_NTF_CONNECTIONS = n2;
    }

    public static int getMaxNtfConnection() {
        if (MAX_NTF_CONNECTIONS == 0) {
            return 16;
        }
        return MAX_NTF_CONNECTIONS;
    }

    NTFJMSConnectionGroup(String string) {
        this.uniqueIdentifier = string;
    }

    synchronized void checkForActiveRegistrations() {
        if (this.noOfRegistrationsInThisGroup == 0) {
            if (!this.jmsListenerConnections.isEmpty()) {
                for (NTFJMSConnection nTFJMSConnection : this.jmsListenerConnections) {
                    if (nTFJMSConnection == null) continue;
                    nTFJMSConnection.setNeedToBeClosed(true);
                    nTFJMSConnection.interrupt();
                    nTFJMSConnection.closeThisListener();
                    --this.aliveConnections;
                }
                this.jmsListenerConnections.clear();
            }
            PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
        }
    }

    synchronized void startJMSListenerConnection(String string, String string2, String string3, String string4, ArrayList<String> arrayList, String string5, int n2) {
        assert (string5 != null) : "jmsConnectionId is null";
        String string6 = "notify" + string5;
        NTFJMSConnection nTFJMSConnection = new NTFJMSConnection(string5, arrayList, string, string2, string3, string4, string6, n2);
        this.jmsListenerConnections.add(nTFJMSConnection);
        nTFJMSConnection.setDaemon(true);
        nTFJMSConnection.start();
        ++this.aliveConnections;
    }

    synchronized void decrementNumberOfRegistrations() {
        --this.noOfRegistrationsInThisGroup;
    }

    synchronized NTFJMSConnection getNTFJMSConnection(int n2) {
        this.noOfRegistrationsInThisGroup += n2;
        if (this.noOfRegistrationsInThisGroup > NTFJMSConnectionGroup.getMaxNtfConnection()) {
            int n3 = this.noOfRegistrationsInThisGroup;
            NTFJMSConnection nTFJMSConnection = this.jmsListenerConnections.get(0);
            for (NTFJMSConnection nTFJMSConnection2 : this.jmsListenerConnections) {
                int n4 = nTFJMSConnection2.getNumberOfRegistrations();
                if (n4 >= n3) continue;
                nTFJMSConnection = nTFJMSConnection2;
                n3 = n4;
            }
            nTFJMSConnection.incrementNumberOfRegistrations(n2);
            return nTFJMSConnection;
        }
        return null;
    }

    synchronized void resetRegistrationNumbers(int n2, NTFJMSConnection nTFJMSConnection) {
        this.noOfRegistrationsInThisGroup -= n2;
        if (nTFJMSConnection != null) {
            nTFJMSConnection.decrementNumberOfRegistrations(n2);
        }
    }

    synchronized void raiseException() {
        --this.aliveConnections;
        if (this.aliveConnections == 0) {
            NTFJMSRegistration nTFJMSRegistration = null;
            Iterator<Long> iterator = this.jmsRegIdToNtfReg.keySet().iterator();
            while (iterator.hasNext()) {
                nTFJMSRegistration = this.jmsRegIdToNtfReg.get(iterator.next());
                try {
                    nTFJMSRegistration.raiseException(1);
                }
                catch (Exception exception) {}
            }
        }
    }

    void addNtfRegistrationByRegId(long l2, NTFJMSRegistration nTFJMSRegistration) {
        this.jmsRegIdToNtfReg.put(l2, nTFJMSRegistration);
    }

    NTFJMSRegistration getNtfRegistrationByRegId(long l2) {
        return this.jmsRegIdToNtfReg.get(l2);
    }

    NTFJMSRegistration removeNtfRegistrationByRegId(long l2) {
        return this.jmsRegIdToNtfReg.remove(l2);
    }
}

