/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.server.auth.IPAuthenticationProvider;

public class ProviderRegistry {
    private static final Logger LOG = Logger.getLogger(ProviderRegistry.class);
    private static boolean initialized = false;
    private static HashMap<String, AuthenticationProvider> authenticationProviders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<ProviderRegistry> clazz = ProviderRegistry.class;
        synchronized (ProviderRegistry.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            IPAuthenticationProvider ipp = new IPAuthenticationProvider();
            DigestAuthenticationProvider digp = new DigestAuthenticationProvider();
            authenticationProviders.put(ipp.getScheme(), ipp);
            authenticationProviders.put(digp.getScheme(), digp);
            Enumeration<Object> en = System.getProperties().keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                if (!k.startsWith("zookeeper.authProvider.")) continue;
                String className = System.getProperty(k);
                try {
                    Class<?> c = ZooKeeperServer.class.getClassLoader().loadClass(className);
                    AuthenticationProvider ap = (AuthenticationProvider)c.newInstance();
                    authenticationProviders.put(ap.getScheme(), ap);
                }
                catch (Exception e) {
                    LOG.warn("Problems loading " + className, e);
                }
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static AuthenticationProvider getProvider(String scheme) {
        if (!initialized) {
            ProviderRegistry.initialize();
        }
        return authenticationProviders.get(scheme);
    }

    public static String listProviders() {
        StringBuilder sb = new StringBuilder();
        for (String s : authenticationProviders.keySet()) {
            sb.append(s + " ");
        }
        return sb.toString();
    }
}

