/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton;

import choco.kernel.model.constraints.automaton.State;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Pattern;

public class LayeredDFA {
    protected int[] domSizes;
    protected int[] offsets;
    protected State initState;
    protected State lastState;
    protected int nbState = 0;
    protected ArrayList<State>[] levelStates;
    protected int nbLevel;

    public LayeredDFA(int domSize, int nblevel) {
        int i;
        this.domSizes = new int[nblevel];
        for (i = 0; i < nblevel - 1; ++i) {
            this.domSizes[i] = domSize;
        }
        this.domSizes[nblevel - 1] = 0;
        this.offsets = new int[nblevel];
        this.nbLevel = nblevel;
        this.levelStates = new ArrayList[nblevel];
        for (i = 0; i < this.levelStates.length; ++i) {
            this.levelStates[i] = new ArrayList();
        }
        this.automatAll();
    }

    public LayeredDFA(int[] domSizes, int nblevel) {
        this.domSizes = new int[nblevel];
        System.arraycopy(domSizes, 0, this.domSizes, 0, domSizes.length);
        this.domSizes[nblevel - 1] = 0;
        this.offsets = new int[nblevel];
        this.nbLevel = nblevel;
        this.levelStates = new ArrayList[nblevel];
        for (int i = 0; i < this.levelStates.length; ++i) {
            this.levelStates[i] = new ArrayList();
        }
        this.automatAll();
    }

    public void automatAll() {
        this.nbState = 0;
        State currentState = this.makeState(this, 0);
        this.setInitState(currentState);
        for (int i = 1; i < this.nbLevel; ++i) {
            State nextState = this.makeState(this, i);
            for (int j = 0; j < this.domSizes[i - 1]; ++j) {
                currentState.addNext(nextState, j);
            }
            currentState = nextState;
        }
        this.setLastState(currentState);
    }

    public void clearAutomate() {
        for (int i = 0; i < this.levelStates.length; ++i) {
            this.levelStates[i] = new ArrayList();
        }
        this.nbState = 0;
        State currentState = this.makeState(this, 0);
        this.setInitState(currentState);
        currentState = this.makeState(this, this.levelStates.length - 1);
        this.setLastState(currentState);
    }

    public void buildAnEmptyAutomaton() {
        for (int i = 0; i < this.levelStates.length; ++i) {
            this.levelStates[i] = new ArrayList();
        }
        this.nbState = 0;
        this.setInitState(null);
        this.setLastState(null);
    }

    public int getAutomateSize() {
        int tot = 0;
        for (int i = 0; i < this.levelStates.length; ++i) {
            tot += this.levelStates[i].size();
        }
        return tot;
    }

    public int nbTransitions() {
        int tot = 0;
        for (int i = 0; i < this.nbLevel; ++i) {
            for (int j = 0; j < this.levelStates[i].size(); ++j) {
                tot += this.levelStates[i].get((int)j).transitions.getSize();
            }
        }
        return tot;
    }

    public State makeState(LayeredDFA auto, int level) {
        return new State(auto, level);
    }

    public State makeState(State origin) {
        return new State(origin);
    }

    public int getNbLevel() {
        return this.levelStates.length;
    }

    public int getDomSize(int i) {
        return this.domSizes[i];
    }

    public void setDomSize(int layer, int domSize) {
        this.domSizes[layer] = domSize;
    }

    public int getOffset(int i) {
        return this.offsets[i];
    }

    public void setOffset(int layer, int domSize) {
        this.offsets[layer] = domSize;
    }

    public int getNextIdx() {
        return this.nbState++;
    }

    public Iterator getLevelIterator(int level) {
        return this.levelStates[level].iterator();
    }

    public void setInitState(State init) {
        this.initState = init;
    }

    public void setLastState(State last) {
        this.lastState = last;
    }

    public State getInitState() {
        return this.initState;
    }

    public State getLastState() {
        return this.lastState;
    }

    public boolean isEmpty() {
        return this.levelStates[1].isEmpty();
    }

    public State addState(int level) {
        return this.makeState(this, level);
    }

    public void removeState(State st) {
        ArrayList<State> currentAList = this.levelStates[st.getLevel()];
        int idxLevel = st.getIdxLevel();
        st.setIdxLevel(-1);
        if (idxLevel == currentAList.size() - 1) {
            currentAList.remove(idxLevel);
        } else {
            State lastL = currentAList.get(currentAList.size() - 1);
            lastL.setIdxLevel(idxLevel);
            currentAList.set(idxLevel, lastL);
            currentAList.remove(currentAList.size() - 1);
        }
    }

    public void addTransition(State st1, State st2, int transition) {
        st1.addNext(st2, transition);
    }

    public void loadDotty(String fileName) {
        try {
            int i;
            Hashtable<Integer, State> builtStates = new Hashtable<Integer, State>();
            BufferedReader inst = new BufferedReader(new FileReader(new File(fileName)));
            Pattern p = Pattern.compile("\\D+");
            inst.readLine();
            inst.readLine();
            inst.readLine();
            this.nbLevel = Integer.parseInt(p.split(inst.readLine())[1]);
            this.domSizes = new int[this.nbLevel];
            for (i = 0; i < this.nbLevel; ++i) {
                this.domSizes[i] = Integer.parseInt(p.split(inst.readLine())[1]);
            }
            this.levelStates = new ArrayList[this.nbLevel];
            for (i = 0; i < this.levelStates.length; ++i) {
                this.levelStates[i] = new ArrayList();
            }
            String[] nodeInfo = p.split(inst.readLine());
            this.nbState = 0;
            State firstState = this.makeState(this, 0);
            builtStates.put(0, firstState);
            this.setInitState(firstState);
            while (nodeInfo.length != 0) {
                State currentState = (State)builtStates.get(Integer.parseInt(nodeInfo[1]));
                State newState = (State)builtStates.get(Integer.parseInt(nodeInfo[2]));
                if (newState == null) {
                    newState = this.makeState(this, currentState.getLevel() + 1);
                    builtStates.put(Integer.parseInt(nodeInfo[2]), newState);
                    this.setLastState(newState);
                }
                for (int i2 = 3; i2 < nodeInfo.length; ++i2) {
                    currentState.addNext(newState, Integer.parseInt(nodeInfo[i2]));
                }
                nodeInfo = p.split(inst.readLine());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toDotty(String f) {
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(f)));
            bw.write("digraph finite_state_machine {");
            bw.newLine();
            bw.write("rankdir=LR;");
            bw.newLine();
            bw.write("node [shape = circle];");
            bw.newLine();
            bw.write("// nblevel " + this.nbLevel);
            bw.newLine();
            for (i = 0; i < this.domSizes.length; ++i) {
                bw.write("// domSize " + this.domSizes[i]);
                bw.newLine();
            }
            for (i = 0; i < this.nbLevel; ++i) {
                for (int j = 0; j < this.levelStates[i].size(); ++j) {
                    this.levelStates[i].get(j).toDotty(bw);
                }
            }
            bw.write("}");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public State cloneState(State origin) {
        return this.makeState(origin);
    }

    public State cloneState(State origin, Hashtable<State, State> clonedStates, ArrayList<State> newStates) {
        if (origin.getLevel() == 0) {
            return this.getInitState();
        }
        if (origin.getLevel() == this.nbLevel - 1) {
            return this.getLastState();
        }
        State st = clonedStates.get(origin);
        if (st != null) {
            return st;
        }
        st = this.makeState(origin);
        newStates.add(st);
        clonedStates.put(origin, st);
        return st;
    }

    public void removeOffset(int[] tuple) {
        for (int i = 0; i < tuple.length; ++i) {
            if (tuple[i] >= Integer.MAX_VALUE) continue;
            int n = i;
            tuple[n] = tuple[n] - this.offsets[i];
        }
    }

    public void union(int[] tuple) {
        assert (tuple.length == this.nbLevel - 1);
        int[] ctuple = new int[tuple.length];
        System.arraycopy(tuple, 0, ctuple, 0, tuple.length);
        this.removeOffset(ctuple);
        State currentState = this.initState;
        Hashtable<State, State> clonedStates = new Hashtable<State, State>();
        ArrayList<State> newStates = new ArrayList<State>();
        newStates.add(this.initState);
        int size = ctuple.length;
        for (int i = 0; i < size; ++i) {
            int currentAlpha = ctuple[i];
            State newState = currentState.hasNext(currentAlpha) ? this.cloneState(currentState.getNext(currentAlpha), clonedStates, newStates) : (i == size - 1 ? this.getLastState() : this.makeState(this, i + 1));
            currentState.addNext(newState, currentAlpha);
            newStates.add(newState);
            currentState = newState;
        }
        this.removeUnreachablesNodes();
        this.minimize(newStates);
    }

    public void substract(int[] tuple) {
        int[] ctuple = new int[tuple.length];
        System.arraycopy(tuple, 0, ctuple, 0, tuple.length);
        this.removeOffset(ctuple);
        BitSet[] nogoodBS = new BitSet[ctuple.length];
        for (int i = 0; i < tuple.length; ++i) {
            nogoodBS[i] = new BitSet();
            if (ctuple[i] == Integer.MAX_VALUE) {
                nogoodBS[i].set(0, this.domSizes[i]);
                continue;
            }
            nogoodBS[i].set(ctuple[i]);
        }
        this.substract(nogoodBS);
    }

    public void substract(BitSet[] gnogood) {
        State currentState;
        int i;
        Hashtable<State, State> clonedStates = new Hashtable<State, State>();
        ArrayList<State> newStates = new ArrayList<State>();
        newStates.add(this.initState);
        for (int j = 0; j < newStates.size() && (i = (currentState = (State)newStates.get(j)).getLevel()) < gnogood.length; ++j) {
            BitSet currentAlpha = gnogood[i];
            int alpha = currentAlpha.nextSetBit(0);
            while (alpha >= 0) {
                if (currentState.hasNext(alpha)) {
                    State nextState = this.cloneState(currentState.getNext(alpha), clonedStates, newStates);
                    if (i == gnogood.length - 1) {
                        currentState.removeNext(alpha);
                    } else {
                        currentState.addNext(nextState, alpha);
                    }
                }
                alpha = currentAlpha.nextSetBit(alpha + 1);
            }
        }
        this.removeNonTerminalsNodes();
        this.minimize(newStates);
    }

    public void removeUnreachablesNodes() {
        boolean removeU = true;
        for (int i = 1; i < this.nbLevel && removeU; ++i) {
            removeU = false;
            ArrayList<State> currentAL = this.levelStates[i];
            for (int j = currentAL.size() - 1; j > -1; --j) {
                currentAL.get(j).removeIfNoPred();
                removeU = true;
            }
        }
    }

    public void removeGarbageNodes() {
        for (int i = this.nbLevel - 2; i > -1; --i) {
            ArrayList<State> currentAL = this.levelStates[i];
            for (int j = currentAL.size() - 1; j > -1; --j) {
                State st = currentAL.get(j);
                if (st.hasSuccessor()) continue;
                st.removeInTransitions();
                this.removeState(st);
            }
        }
    }

    public void removeNonTerminalsNodes() {
        for (int i = this.nbLevel - 2; i > -1; --i) {
            ArrayList<State> currentAL = this.levelStates[i];
            for (int j = currentAL.size() - 1; j > -1; --j) {
                State st = currentAL.get(j);
                if (st.hasSuccessor()) continue;
                st.removeInTransitions();
                this.removeState(st);
            }
        }
    }

    public void minimize(ArrayList<State> newStates) {
        State st = newStates.get(0);
        block0: for (int i = newStates.size() - 1; i > -1; --i) {
            st = newStates.get(i);
            if (st.getIdxLevel() == -1) continue;
            int currentLvl = st.getLevel();
            for (int j = this.levelStates[currentLvl].size() - 1; j > -1; --j) {
                State st2 = this.levelStates[currentLvl].get(j);
                if (st.equals(st2) || !st.equalState(st2)) continue;
                this.mergeStates(st2, st);
                continue block0;
            }
        }
    }

    public void mergeStates(State st1, State st_supp) {
        st_supp.remplaceRef(st1);
        st_supp.resetState();
        this.removeState(st_supp);
    }
}

