/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.logging.Logger;

public class OneWordSBitSet32
implements IStateBitSet {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final int WORD_MASK = -1;
    private final IEnvironment environment;
    private IStateInt words;

    public OneWordSBitSet32(IEnvironment environment) {
        this.environment = environment;
        this.words = this.environment.makeInt(0);
    }

    public OneWordSBitSet32(IEnvironment environment, int nbits) {
        this.environment = environment;
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (nbits > 32) {
            throw new ArrayIndexOutOfBoundsException("nbits > 32: " + nbits);
        }
        this.words = this.environment.makeInt(0);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return OneWordSBitSet32.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public BitSet copyToBitSet() {
        BitSet view = new BitSet(this.size());
        int i = this.nextSetBit(0);
        while (i >= 0) {
            view.set(i, true);
            i = this.nextSetBit(i + 1);
        }
        return view;
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int tmp = this.words.get();
        this.words.set(tmp ^= 1 << bitIndex);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        OneWordSBitSet32.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        int tmp = this.words.get();
        this.words.set(tmp ^= firstWordMask & lastWordMask);
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.words.set(this.words.get() | 1 << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        OneWordSBitSet32.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.words.set(this.words.get() | firstWordMask & lastWordMask);
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.words.set(this.words.get() & ~(1 << bitIndex));
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        OneWordSBitSet32.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.words.set(this.words.get() & ~(firstWordMask & lastWordMask));
    }

    @Override
    public void clear() {
        this.words.set(0);
    }

    @Override
    public final boolean get(int bitIndex) {
        return (this.words.get() & 1 << bitIndex) != 0;
    }

    public OneWordSBitSet32 get(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextSetBit(int fromIndex) {
        int word = this.words.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex > 32) {
            return this.length() - 1;
        }
        int mask = ~(-1 << fromIndex + 1);
        int word = this.words.get() & (mask != 0 ? mask : -1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > 32) {
            return fromIndex;
        }
        int mask = ~(-1 << fromIndex + 1);
        int word = ~this.words.get() & (mask != 0 ? mask : -1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int capacity() {
        return 32;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex > 32) {
            return fromIndex;
        }
        int word = ~this.words.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return 32;
    }

    public int length() {
        return 32 - Integer.numberOfLeadingZeros(this.words.get());
    }

    @Override
    public boolean isEmpty() {
        return this.words.get() == 0;
    }

    @Override
    public int cardinality() {
        return Integer.bitCount(this.words.get());
    }

    @Override
    public void and(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void or(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void xor(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void andNot(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int h = 1234;
        return (h ^= this.words.get()) >> 16 ^ h;
    }

    @Override
    public int size() {
        return 32;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OneWordSBitSet32)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneWordSBitSet32 set = (OneWordSBitSet32)obj;
        return this.words == set.words;
    }

    @Override
    public IStateBitSet copy() {
        OneWordSBitSet32 result = new OneWordSBitSet32(this.environment, this.size());
        result.words.set(this.words.get());
        return result;
    }

    public String toString() {
        int numBits = 32;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

