/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.Choco;
import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.constraints.integer.extension.AC2001BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBitBinSConstraint;
import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.FCBinSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001LargeSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001PositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmPositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GACstrPositiveLargeSConstraint;
import choco.cp.solver.variables.integer.BitSetIntDomain;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.IterLargeRelation;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class TableManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] vars, Object parameters, List<String> options) {
        Object[] ps = (Object[])parameters;
        IntegerVariable[] vars2 = new IntegerVariable[vars.length];
        System.arraycopy(vars, 0, vars2, 0, vars.length);
        IntDomainVar[] vs = solver.getVar(vars2);
        if (vs.length == 2 && !options.contains("cp:ac2008") && !(ps[1] instanceof LargeRelation)) {
            return this.buildBinaryTable(vs, parameters, options, solver.getEnvironment());
        }
        return this.buildNaryTable(vs, parameters, options, solver.getEnvironment());
    }

    public SConstraint buildBinaryTable(IntDomainVar[] vs, Object parameters, List<String> options, IEnvironment environment) {
        Object[] ps = (Object[])parameters;
        IntDomainVar v1 = vs[0];
        IntDomainVar v2 = vs[1];
        if (ps[1] instanceof BinRelation) {
            return this.buildBinaryTable(v1, v2, (BinRelation)ps[1], options, environment);
        }
        boolean feas = (Boolean)ps[0];
        BinRelation binR = this.makePairAC(v1, v2, ps[1], feas, options);
        return this.buildBinaryTable(v1, v2, binR, options, environment);
    }

    public SConstraint buildBinaryTable(IntDomainVar v1, IntDomainVar v2, BinRelation binR, List<String> options, IEnvironment environment) {
        if (options.contains("cp:fc")) {
            return new FCBinSConstraint(v1, v2, binR);
        }
        if (options.contains("cp:ac3")) {
            return new AC3BinSConstraint(v1, v2, binR);
        }
        if (options.contains("cp:ac32")) {
            return new AC3rmBinSConstraint(v1, v2, binR);
        }
        if (options.contains("cp:ac322")) {
            return new AC3rmBitBinSConstraint(v1, v2, (CouplesBitSetTable)binR);
        }
        if (options.contains("cp:ac2001")) {
            return new AC2001BinSConstraint(v1, v2, binR, environment);
        }
        if (binR instanceof CouplesBitSetTable && v1.getDomain() instanceof BitSetIntDomain && v2.getDomain() instanceof BitSetIntDomain) {
            return new AC3rmBitBinSConstraint(v1, v2, (CouplesBitSetTable)binR);
        }
        return new AC3rmBinSConstraint(v1, v2, binR);
    }

    private BinRelation makePairAC(IntDomainVar x, IntDomainVar y, Object mat, boolean feas, List<String> options) {
        int[] min = new int[]{x.getInf(), y.getInf()};
        int[] max = new int[]{x.getSup(), y.getSup()};
        if (mat instanceof List) {
            return Choco.makeBinRelation(min, max, (List)mat, feas, options.contains("cp:ac322"));
        }
        if (mat instanceof boolean[][]) {
            return Choco.makeBinRelation(min, max, (boolean[][])mat, feas, options.contains("cp:ac322"));
        }
        throw new ModelException("a relation should be given a List<int[]> or boolean[][]");
    }

    public SConstraint buildNaryTable(IntDomainVar[] vs, Object parameters, List<String> options, IEnvironment environment) {
        Object[] ps = (Object[])parameters;
        if (ps[1] instanceof LargeRelation) {
            return this.buildNaryTable(vs, (LargeRelation)ps[1], options, environment);
        }
        boolean feas = (Boolean)ps[0];
        LargeRelation rela = this.makeTupleAC(vs, (List)ps[1], feas, options);
        return this.buildNaryTable(vs, rela, options, environment);
    }

    public SConstraint buildNaryTable(IntDomainVar[] vs, LargeRelation rela, List<String> options, IEnvironment environment) {
        if (options.contains("cp:fc")) {
            return new CspLargeSConstraint(vs, rela);
        }
        if (rela instanceof IterLargeRelation) {
            if (options.contains("cp:ac32")) {
                return new GAC3rmPositiveLargeConstraint(vs, (IterTuplesTable)rela);
            }
            if (options.contains("cp:ac2001")) {
                return new GAC2001PositiveLargeConstraint(environment, vs, (IterTuplesTable)rela);
            }
            return new GAC3rmPositiveLargeConstraint(vs, (IterTuplesTable)rela);
        }
        if (options.contains("cp:ac32")) {
            return new GAC3rmLargeConstraint(vs, rela);
        }
        if (options.contains("cp:ac2001")) {
            return new GAC2001LargeSConstraint(vs, rela, environment);
        }
        if (options.contains("cp:ac2008") && rela instanceof TuplesList) {
            return new GACstrPositiveLargeSConstraint(vs, rela, environment);
        }
        return new GAC3rmLargeConstraint(vs, rela);
    }

    private LargeRelation makeTupleAC(IntDomainVar[] vs, List<int[]> tuples, boolean feas, List<String> options) {
        int[] min = new int[vs.length];
        int[] max = new int[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            min[i] = vs[i].getInf();
            max[i] = vs[i].getSup();
        }
        if (options.contains("cp:ac2008")) {
            return Choco.makeLargeRelation(min, max, tuples, feas, 2);
        }
        if (options.contains("cp:fc")) {
            return Choco.makeLargeRelation(min, max, tuples, feas, 1);
        }
        return Choco.makeLargeRelation(min, max, tuples, feas);
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        if (options.contains("cp:ac322")) {
            return new int[]{0};
        }
        return new int[]{0, 4, 1};
    }
}

