/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.JADE;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class JADEGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double[] CrossOverRate;
    private int Strategy;
    private String CrossoverType;
    private double p;
    private double c;
    protected int numberOfClass;
    protected int numberOfbetters;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;

    public JADEGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "JADE";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.ScalingFactor = F;
        this.Strategy = strg;
    }

    public JADEGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "JADE";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.p = parameters.getNextAsDouble();
        this.c = parameters.getNextAsDouble();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.numberOfbetters = (int)(this.p * (double)this.PopulationSize);
        if (this.numberOfbetters < 1) {
            this.numberOfbetters = 1;
        }
        System.out.println("Numero de p-best = " + this.numberOfbetters);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " CR=  " + this.CrossOverRate + "\n");
    }

    public int[] mejoresParticulas(PrototypeSet[] population, double[] fitness) {
        double acc;
        int number = this.numberOfbetters;
        int[] index = new int[number];
        int ind = 0;
        double mejor = Double.MIN_VALUE;
        for (int i = 0; i < population.length; ++i) {
            acc = fitness[i];
            if (!(acc > mejor)) continue;
            ind = i;
            mejor = acc;
        }
        index[0] = ind;
        for (int j = 1; j < number; ++j) {
            mejor = Double.MIN_VALUE;
            for (int i = 0; i < population.length; ++i) {
                acc = fitness[i];
                if (!(acc > mejor) || !(acc < fitness[index[j - 1]])) continue;
                ind = i;
                mejor = acc;
            }
            index[j] = ind;
        }
        return index;
    }

    public PrototypeSet mutant(PrototypeSet[] population, double[] fitness, int actual, PrototypeSet[] Archivo, int utilArchivo) {
        int number;
        int ran;
        PrototypeSet mutant = new PrototypeSet(population.length);
        while ((ran = RandomGenerator.Randint(0, population.length)) == actual) {
        }
        PrototypeSet r1 = population[ran];
        while ((number = RandomGenerator.Randint(0, population.length + utilArchivo)) == ran || number == actual) {
        }
        PrototypeSet r2 = number < population.length ? population[number] : Archivo[number - population.length];
        int[] indices = new int[this.numberOfbetters];
        indices = this.mejoresParticulas(population, fitness);
        number = RandomGenerator.Randint(0, indices.length);
        PrototypeSet xbest = population[indices[number]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = xbest.restar(population[actual]);
                PrototypeSet resta2 = r1.restar(r2);
                PrototypeSet producto = resta.mulEscalar(this.ScalingFactor);
                PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
                PrototypeSet result = producto.sumar(producto2);
                mutant = population[actual].sumar(result);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        int j;
        int i;
        System.out.print("\nThe algorithm  JADE is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        if (this.numberOfPrototypes < this.trainingDataSet.getPosibleValuesOfOutput().size()) {
            System.out.println("Number of prototypes less than the number of clases");
            this.numberOfPrototypes = this.trainingDataSet.getPosibleValuesOfOutput().size();
        }
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        double meanCR = 0.5;
        double meanF = 0.5;
        PrototypeSet[] Archivo = new PrototypeSet[this.PopulationSize];
        int utilArchivo = 0;
        double[] SF = new double[this.PopulationSize];
        double[] SCR = new double[this.PopulationSize];
        this.CrossOverRate = new double[this.PopulationSize];
        double[] F = new double[this.PopulationSize];
        population[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i = 0; i < this.numberOfClass; ++i) {
            clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
        }
        for (i = 0; i < population[0].size(); ++i) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                population[0].add(clases[j].getRandom());
            }
        }
        fitness[0] = JADEGenerator.accuracy(population[0], this.trainingDataSet);
        for (i = 1; i < this.PopulationSize; ++i) {
            population[i] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                population[i].add(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i] = JADEGenerator.accuracy(population[i], this.trainingDataSet);
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (int i2 = 1; i2 < this.PopulationSize; ++i2) {
            if (!(fitness[i2] > bestFitness)) continue;
            bestFitness = fitness[i2];
            bestFitnessIndex = i2;
        }
        for (int j2 = 0; j2 < this.PopulationSize; ++j2) {
            for (int i3 = 0; i3 < population[j2].size(); ++i3) {
                ((Prototype)population[j2].get(i3)).setIndex(i3);
            }
        }
        System.out.println("Initial Fitness=  " + bestFitness);
        this.Strategy = 1;
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            int utilF = 0;
            int utilCR = 0;
            for (int i4 = 0; i4 < this.PopulationSize; ++i4) {
                this.CrossOverRate[i4] = RandomGenerator.RandGaussian() * 0.1 + meanCR;
                if (this.CrossOverRate[i4] > 1.0) {
                    this.CrossOverRate[i4] = 1.0;
                }
                if (this.CrossOverRate[i4] < 0.0) {
                    this.CrossOverRate[i4] = 0.0;
                }
                do {
                    double uniforme = RandomGenerator.Randdouble(0.0, 1.0);
                    F[i4] = 0.1 * Math.tan(3.14161 * uniforme) + meanF;
                } while (F[i4] <= 0.0);
                if (F[i4] > 1.0) {
                    F[i4] = 1.0;
                }
                this.ScalingFactor = F[i4];
                mutation[i4] = new PrototypeSet(population[i4].clone());
                mutation[i4] = this.mutant(population, fitness, i4, Archivo, utilArchivo).clone();
                crossover[i4] = new PrototypeSet(population[i4].clone());
                for (int j3 = 0; j3 < population[i4].size(); ++j3) {
                    double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                    if (!(randNumber < this.CrossOverRate[i4])) continue;
                    crossover[i4].set(j3, mutation[i4].get(j3));
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i4]);
                fitness[i4] = JADEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i4]);
                double trialVector = JADEGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i4]) {
                    Archivo[utilArchivo % this.PopulationSize] = new PrototypeSet(population[i4].clone());
                    ++utilArchivo;
                    SCR[utilCR % this.PopulationSize] = this.CrossOverRate[i4];
                    ++utilCR;
                    SF[utilF % this.PopulationSize] = F[i4];
                    ++utilF;
                    population[i4] = new PrototypeSet(crossover[i4].clone());
                    fitness[i4] = trialVector;
                    utilArchivo %= this.PopulationSize;
                }
                if (!(fitness[i4] > bestFitness)) continue;
                bestFitness = fitness[i4];
                bestFitnessIndex = i4;
                System.out.println("Iter=" + iter + " Acc= " + bestFitness);
            }
            if (utilArchivo > this.PopulationSize) {
                utilArchivo = this.PopulationSize;
            }
            double meanA = 0.0;
            double meanL = 0.0;
            double numerator = 0.0;
            double denominator = 0.0;
            for (int i5 = 0; i5 < utilCR; ++i5) {
                meanA += SCR[i5];
                numerator += SF[i5] * SF[i5];
                denominator += SF[i5];
            }
            meanL = numerator / denominator;
            meanCR = (1.0 - this.c) * meanCR + this.c * meanA;
            meanF = (1.0 - this.c) * meanF + this.c * meanL;
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("JADE", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        JADEGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        JADEGenerator generator = new JADEGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

