/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IO {
    private IO() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static @NonNull Optional<File> getFile(@NonNull Path path) {
        try {
            return Optional.of(path.toFile());
        }
        catch (UnsupportedOperationException ex) {
            return Optional.empty();
        }
    }

    public static @NonNull Optional<InputStream> getResourceAsStream(@NonNull Class<?> type, @NonNull String name) {
        return Optional.ofNullable(type.getResourceAsStream(name));
    }

    public static <X extends Throwable> void ensureClosed(@NonNull X exception, @NonNull Closeable closeable) {
        Objects.requireNonNull(exception);
        try {
            closeable.close();
        }
        catch (IOException suppressed) {
            try {
                exception.addSuppressed(suppressed);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static <S, R, VALUE> @NonNull Function<S, VALUE> valueOf(@NonNull Function<? super S, ? extends R> opener, @NonNull Function<? super R, ? extends VALUE> reader, @NonNull Consumer<? super R> closer) {
        Objects.requireNonNull(opener);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(closer);
        return source -> {
            Object resource = opener.applyWithIO((Object)source);
            try (Closeable c = () -> closer.acceptWithIO((Object)resource);){
                Object r = reader.applyWithIO((Object)resource);
                return r;
            }
        };
    }

    static <S, R, FLOW extends AutoCloseable> @NonNull Function<S, FLOW> flowOf(@NonNull Function<? super S, ? extends R> opener, @NonNull Function<? super R, ? extends FLOW> reader, @NonNull Consumer<? super R> closer) {
        Objects.requireNonNull(opener);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(closer);
        return source -> {
            Object resource = opener.applyWithIO((Object)source);
            try {
                return (AutoCloseable)reader.applyWithIO((Object)resource);
            }
            catch (IOException | Error | RuntimeException e) {
                IO.ensureClosed(e, () -> closer.acceptWithIO((Object)resource));
                throw e;
            }
        };
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R applyWithIO(T var1) throws IOException;

        default public <V> @NonNull Function<V, R> compose(@NonNull Function<? super V, ? extends T> before) {
            Objects.requireNonNull(before);
            return v -> this.applyWithIO(before.applyWithIO((Object)v));
        }

        default public <V> @NonNull Function<T, V> andThen(@NonNull Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return t -> after.applyWithIO((R)this.applyWithIO(t));
        }

        default public java.util.function.Function<T, R> asUnchecked() {
            return t -> {
                try {
                    return this.applyWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        public static <T, R> java.util.function.Function<T, R> unchecked(@NonNull Function<T, R> o) {
            return o.asUnchecked();
        }

        public static <T, R> Function<T, R> checked(java.util.function.Function<T, R> func) {
            Objects.requireNonNull(func);
            return o -> {
                try {
                    return func.apply(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        public static <T, R> @NonNull Function<T, R> throwing(java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        public static <T> @NonNull Function<T, T> identity() {
            return t -> t;
        }

        public static <T, R> @NonNull Function<T, R> of(@Nullable R r) {
            return o -> r;
        }
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void acceptWithIO(T var1) throws IOException;

        default public @NonNull Consumer<T> andThen(@NonNull Consumer<? super T> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.acceptWithIO(t);
                after.acceptWithIO(t);
            };
        }

        default public java.util.function.Consumer<T> asUnchecked() {
            return t -> {
                try {
                    this.acceptWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        public static <T> java.util.function.Consumer<T> unchecked(@NonNull Consumer<T> o) {
            return o.asUnchecked();
        }

        public static <T> Consumer<T> checked(java.util.function.Consumer<T> consumer) {
            return o -> {
                try {
                    consumer.accept(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        public static <T> @NonNull Consumer<T> throwing(java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        public static <T> @NonNull Consumer<T> noOp() {
            return o -> {};
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    private static @interface JdkWithIO {
        public String value() default "";
    }

    public static final class Stream {
        private Stream() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static <T extends Closeable, R> java.util.stream.Stream<R> open(Supplier<T> source, Function<? super T, java.util.stream.Stream<R>> streamer) throws IOException {
            return Stream.asParser(streamer).applyWithIO(source);
        }

        public static <T> java.util.stream.Stream<T> generateUntilNull(@NonNull Supplier<T> generator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Stream.asIterator(generator), 272), false);
        }

        private static <C extends Closeable, R> Function<Supplier<C>, java.util.stream.Stream<R>> asParser(Function<? super C, java.util.stream.Stream<R>> streamer) {
            return IO.flowOf(source -> (Closeable)source.getWithIO(), resource -> (java.util.stream.Stream)((java.util.stream.Stream)streamer.applyWithIO((Object)resource)).onClose(Runnable.unchecked(resource::close)), Closeable::close);
        }

        private static <T> @NonNull Iterator<T> asIterator(final @NonNull Supplier<T> nextSupplier) {
            Objects.requireNonNull(nextSupplier);
            return new Iterator<T>(){
                T nextElement = null;

                @Override
                public boolean hasNext() {
                    if (this.nextElement != null) {
                        return true;
                    }
                    try {
                        this.nextElement = nextSupplier.getWithIO();
                        return this.nextElement != null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public T next() {
                    if (this.nextElement != null || this.hasNext()) {
                        Object line = this.nextElement;
                        this.nextElement = null;
                        return line;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }

    public static interface Resource<K>
    extends ResourceLoader<K>,
    ResourceStorer<K> {
    }

    public static interface ResourceStorer<K>
    extends Closeable {
        public void store(@NonNull K var1, @NonNull OutputStream var2) throws IOException, IllegalStateException;
    }

    public static interface ResourceLoader<K>
    extends Closeable {
        public @NonNull InputStream load(@NonNull K var1) throws IOException, IllegalStateException;

        public static <K> @NonNull ResourceLoader<K> of(@NonNull Function<? super K, ? extends InputStream> loader) {
            return ResourceLoader.of(loader, Runnable.noOp().asCloseable());
        }

        public static <K> @NonNull ResourceLoader<K> of(final @NonNull Function<? super K, ? extends InputStream> loader, final @NonNull Closeable closer) {
            Objects.requireNonNull(loader);
            Objects.requireNonNull(closer);
            return new ResourceLoader<K>(){
                boolean closed = false;

                @Override
                public InputStream load(K key) throws IOException {
                    Objects.requireNonNull(key);
                    if (this.closed) {
                        throw new IllegalStateException("Closed");
                    }
                    InputStream result = (InputStream)loader.applyWithIO(key);
                    if (result == null) {
                        throw new IOException("Null stream");
                    }
                    return result;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                    closer.close();
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Predicate<T> {
        public boolean testWithIO(T var1) throws IOException;

        default public @NonNull Predicate<T> and(@NonNull Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.testWithIO(t) && other.testWithIO(t);
        }

        default public @NonNull Predicate<T> negate() {
            return t -> !this.testWithIO(t);
        }

        default public @NonNull Predicate<T> or(@NonNull Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.testWithIO(t) || other.testWithIO(t);
        }

        default public java.util.function.Predicate<T> asUnchecked() {
            return t -> {
                try {
                    return this.testWithIO(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        public static <T> java.util.function.Predicate<T> unchecked(@NonNull Predicate<T> o) {
            return o.asUnchecked();
        }

        public static <T> Predicate<T> checked(java.util.function.Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            return o -> {
                try {
                    return predicate.test(o);
                }
                catch (UncheckedIOException ex) {
                    throw ex.getCause();
                }
            };
        }

        public static <T> @NonNull Predicate<T> throwing(java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return o -> {
                throw (IOException)ex.get();
            };
        }

        public static <T> @NonNull Predicate<T> isEqual(Object targetRef) {
            return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
        }

        public static <T> @NonNull Predicate<T> of(boolean r) {
            return o -> r;
        }
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T getWithIO() throws IOException;

        default public java.util.function.Supplier<T> asUnchecked() {
            return () -> {
                try {
                    return this.getWithIO();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        public static <T> java.util.function.Supplier<T> unchecked(Supplier<T> o) {
            return o.asUnchecked();
        }

        public static <T> @NonNull Supplier<T> checked(java.util.function.Supplier<T> o) {
            Objects.requireNonNull(o);
            return () -> {
                try {
                    return o.get();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            };
        }

        public static <T> @NonNull Supplier<T> throwing(java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return () -> {
                throw (IOException)ex.get();
            };
        }

        public static <T> @NonNull Supplier<T> of(@Nullable T t) {
            return () -> t;
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void runWithIO() throws IOException;

        default public @NonNull Closeable asCloseable() {
            return this::runWithIO;
        }

        default public java.lang.Runnable asUnchecked() {
            return () -> {
                try {
                    this.runWithIO();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        public static java.lang.Runnable unchecked(@NonNull Runnable o) {
            return o.asUnchecked();
        }

        public static @NonNull Runnable checked(java.lang.Runnable o) {
            return () -> {
                try {
                    o.run();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            };
        }

        public static @NonNull Runnable throwing(java.util.function.Supplier<? extends IOException> ex) {
            Objects.requireNonNull(ex);
            return () -> {
                throw (IOException)ex.get();
            };
        }

        public static @NonNull Runnable noOp() {
            return () -> {};
        }
    }
}

