/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.modelling.arima.IDifferencingModule;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Exception;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class DifferencingModule
implements IDifferencingModule {
    public static final int MAXD = 2;
    public static final int MAXBD = 1;
    private double eps_ = 1.0E-5;
    private DataBlock data_ = null;
    private SarimaSpecification spec_ = new SarimaSpecification();
    private SarimaModel lastModel_;
    private double rmax_;
    private double rsmax_;
    private double c_;
    private double ub1_ = 0.97;
    private double ub2_ = 0.88;
    private double cancel_ = 0.1;
    private int iter_;
    private boolean ml_;
    private boolean useml_;
    private boolean mlused_;
    private boolean bcalc_;
    private int maxd = 2;
    private int maxbd = 1;

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    private static double removeMean(DataBlock data) {
        int n = data.getLength();
        double m = data.sum() / (double)n;
        data.sub(m);
        return m;
    }

    private void allcond() {
        if (this.spec_.getD() + this.spec_.getBD() != 0) {
            return;
        }
        double ar = this.lastModel_.phi(1);
        if (!this.hasSeas()) {
            if (Math.abs(ar + 1.0) <= 0.15) {
                this.spec_.setD(this.spec_.getD() + 1);
            }
        } else {
            double sar = this.lastModel_.bphi(1);
            if (Math.abs(ar + 1.0) <= 0.15 || Math.abs(sar + 1.0) <= 0.25) {
                this.rmax_ = -ar;
                this.rsmax_ = -sar;
                if (ar < sar) {
                    this.spec_.setD(this.spec_.getD() + 1);
                } else {
                    this.spec_.setBD(this.spec_.getBD() + 1);
                }
            }
        }
    }

    private void calc() {
        if (this.data_ == null || this.bcalc_) {
            return;
        }
        this.c_ = this.cancel_;
        this.useml_ = false;
        this.mlused_ = false;
        this.bcalc_ = true;
        this.rsmax_ = 0.0;
        this.rmax_ = 0.0;
        this.step0();
        this.iter_ = 0;
        while (this.nextstep() && this.iter_ < 5) {
            ++this.iter_;
        }
    }

    public void clear() {
        this.lastModel_ = null;
        this.spec_ = new SarimaSpecification();
        this.bcalc_ = false;
        this.data_ = null;
        this.useml_ = false;
    }

    private int cond1(int icon) {
        if (this.spec_.getD() + this.spec_.getBD() != 0) {
            return icon;
        }
        double ar = this.lastModel_.phi(1);
        double ma = this.lastModel_.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.hasSeas()) {
            sar = this.lastModel_.bphi(1);
            sma = this.lastModel_.btheta(1);
        }
        if ((Math.abs(ar - ma) < this.c_ || this.hasSeas() && Math.abs(sar - sma) < this.c_) && (this.rmax_ >= 0.9 || this.rsmax_ >= 0.9)) {
            if (this.useml_ && icon == 1) {
                this.useml_ = false;
            } else {
                ++icon;
            }
            if (this.rmax_ > this.rsmax_) {
                this.spec_.setD(this.spec_.getD() + 1);
            } else {
                this.spec_.setBD(this.spec_.getBD() + 1);
            }
        } else if ((Math.abs(ar + 1.0) <= 0.15 || this.hasSeas() && Math.abs(sar + 1.0) <= 0.16) && (this.rmax_ >= 0.9 || this.rsmax_ >= 0.88) || (Math.abs(ar + 1.0) <= 0.16 || this.hasSeas() && Math.abs(sar + 1.0) <= 0.17) && (this.rmax_ >= 0.91 || this.rsmax_ >= 0.89)) {
            if (this.useml_ && icon == 1) {
                this.useml_ = false;
            } else {
                ++icon;
            }
            if (this.rmax_ > this.rsmax_) {
                this.spec_.setD(this.spec_.getD() + 1);
            } else {
                this.spec_.setBD(this.spec_.getBD() + 1);
            }
        }
        return icon;
    }

    private int finalcond(int icon) {
        if (icon == 2) {
            this.spec_.setD(this.spec_.getD() - 1);
            this.spec_.setBD(this.spec_.getBD() - 1);
            if (this.mlused_) {
                if (this.lastModel_.phi(1) < this.lastModel_.bphi(1)) {
                    this.spec_.setD(this.spec_.getD() + 1);
                } else {
                    this.spec_.setBD(this.spec_.getBD() + 1);
                }
            } else if (this.rmax_ > this.rsmax_) {
                if (this.rmax_ > 0.0) {
                    this.spec_.setD(this.spec_.getD() + 1);
                }
            } else if (this.rsmax_ > 0.0) {
                this.spec_.setBD(this.spec_.getBD() + 1);
            }
        }
        if (this.spec_.getD() > this.maxd) {
            this.spec_.setD(this.maxd);
            icon = 0;
        }
        if (this.spec_.getBD() > this.maxbd) {
            this.spec_.setBD(this.maxbd);
            icon = 0;
        }
        return icon;
    }

    @Override
    public int getBD() {
        return this.spec_.getBD();
    }

    @Override
    public int getD() {
        return this.spec_.getD();
    }

    public BackFilter getDifferencingFilter() {
        return this.spec_.getDifferencingFilter();
    }

    public double getUB1() {
        return this.ub1_;
    }

    public double getUB2() {
        return this.ub2_;
    }

    public double getCancel() {
        return this.cancel_;
    }

    private boolean hasSeas() {
        return this.maxbd > 0 && this.spec_.getFrequency() > 1;
    }

    private void initstep(boolean bstart) {
        boolean usedefault;
        DataBlock data;
        BackFilter ur;
        if (this.spec_.getD() == 0 && this.spec_.getBD() == 0 && bstart) {
            if (this.spec_.getFrequency() != 2) {
                this.spec_.setP(2);
            } else {
                this.spec_.setP(1);
            }
            this.spec_.setQ(0);
            this.spec_.setBQ(0);
            if (this.hasSeas()) {
                this.spec_.setBP(1);
            }
        } else {
            this.spec_.setP(1);
            this.spec_.setQ(1);
            if (this.spec_.getFrequency() > 1) {
                this.spec_.setBP(1);
                this.spec_.setBQ(1);
            }
        }
        if ((ur = this.spec_.getDifferencingFilter()).getDegree() > 0) {
            data = new DataBlock(this.data_.getLength() - ur.getDegree());
            ur.filter(this.data_, data);
        } else {
            data = this.data_.deepClone();
        }
        DifferencingModule.removeMean(data);
        HannanRissanen hr = new HannanRissanen();
        boolean bl = usedefault = !hr.process(data, this.spec_.doStationary());
        if (!usedefault) {
            this.lastModel_ = hr.getModel();
            if (bstart && !this.lastModel_.isStable(true)) {
                if (this.spec_.getP() > 1 || this.spec_.getP() == 1 && Math.abs(this.lastModel_.phi(1)) > 1.02 || this.spec_.getBP() == 1 && Math.abs(this.lastModel_.bphi(1)) > 1.02) {
                    usedefault = true;
                } else {
                    SarimaMapping.stabilize(this.lastModel_);
                }
            }
        }
        if (usedefault) {
            this.lastModel_ = new SarimaModel(this.spec_.doStationary());
        }
        if (usedefault || this.ml_ || this.useml_) {
            SarimaMapping.stabilize(this.lastModel_);
            GlsSarimaMonitor monitor = new GlsSarimaMonitor();
            monitor.setPrecision(this.eps_);
            RegArimaModel<SarimaModel> model = new RegArimaModel<SarimaModel>(new SarimaModel(this.spec_), this.data_);
            RegArimaEstimation<SarimaModel> rslt = monitor.optimize(model, this.lastModel_);
            if (rslt == null) {
                throw new X13Exception("Non convergence in IDDIF");
            }
            this.lastModel_.setParameters(((SarimaModel)rslt.model.getArima()).getParameters());
            this.mlused_ = true;
        } else {
            this.mlused_ = false;
        }
        this.useml_ = false;
    }

    public boolean isUsingML() {
        return this.ml_;
    }

    private int maincondition() {
        double ar = this.lastModel_.phi(1);
        double ma = this.lastModel_.theta(1);
        double sar = 0.0;
        double sma = 0.0;
        if (this.spec_.getFrequency() > 1) {
            sar = this.lastModel_.bphi(1);
            sma = this.lastModel_.btheta(1);
        }
        double din = 0.0;
        this.c_ -= 0.002;
        din = !this.mlused_ && this.ub2_ >= 0.869 ? 0.136 : 1.005 - this.ub2_;
        int icon = 0;
        if (Math.abs(ar + 1.0) <= din) {
            if (-ar > 1.02) {
                icon = 1;
                this.useml_ = true;
            } else if (Math.abs(ar - ma) > this.c_) {
                ++icon;
                this.spec_.setD(this.spec_.getD() + 1);
            }
        } else if (Math.abs(ar) > 1.12) {
            icon = 1;
            this.useml_ = true;
        }
        if (this.hasSeas()) {
            if (Math.abs(sar + 1.0) <= 0.19) {
                if (-sar > 1.02) {
                    this.useml_ = true;
                    icon = 1;
                } else if (this.spec_.getBD() == 0 && Math.abs(sar - sma) > this.c_) {
                    ++icon;
                    this.spec_.setBD(this.spec_.getBD() + 1);
                    if (this.useml_) {
                        --icon;
                        this.useml_ = false;
                    }
                }
            } else if (Math.abs(sar) > 1.12) {
                icon = 1;
                this.useml_ = true;
            }
        }
        return icon;
    }

    private boolean nextstep() {
        this.initstep(false);
        int icon = this.maincondition();
        if (this.iter_ == 0) {
            icon = this.cond1(icon);
        }
        this.allcond();
        return this.finalcond(icon) != 0;
    }

    @Override
    public void process(IReadDataBlock data, int freq, int d, int bd) {
        this.clear();
        this.data_ = new DataBlock(data);
        this.spec_.setFrequency(freq);
        this.spec_.setD(d);
        this.spec_.setBD(bd);
        this.calc();
    }

    private int searchur(Complex[] r, double val, boolean regular) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        double vmax = 0.0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (vcur >= val && cdim <= 0.05 && r[i].getRe() > 0.0) {
                ++n;
                continue;
            }
            if (!(cdim <= 0.02) || !(r[i].getRe() > 0.0) || !(vcur > vmax)) continue;
            vmax = vcur;
        }
        if (regular) {
            this.rmax_ = vmax;
        } else {
            this.rsmax_ = vmax;
        }
        return n;
    }

    public void setCancel(double value) {
        this.cancel_ = value;
        this.clear();
    }

    public void setUB1(double value) {
        this.ub1_ = value;
        this.clear();
    }

    public void setUB2(double value) {
        this.ub2_ = value;
        this.clear();
    }

    private void step0() {
        this.initstep(true);
        if (this.spec_.getD() != 0 || this.spec_.getBD() != 0) {
            this.rmax_ = this.lastModel_.phi(1);
            this.rsmax_ = this.lastModel_.bphi(1);
        }
        Complex[] rar = this.lastModel_.getRegularAR().mirror().roots();
        this.spec_.setD(this.spec_.getD() + this.searchur(rar, this.ub1_, true));
        if (this.hasSeas()) {
            Complex[] rsar = this.lastModel_.getSeasonalAR().mirror().roots();
            this.spec_.setBD(this.spec_.getBD() + this.searchur(rsar, this.ub1_, false));
        }
    }

    public void useML(boolean value) {
        this.ml_ = value;
        this.clear();
    }

    @Override
    public boolean isMeanCorrection() {
        if (this.spec_.getDifferenceOrder() == 0) {
            return this.isStMean();
        }
        return this.isNstMean();
    }

    private boolean isStMean() {
        int n = this.data_.getLength();
        double wm = this.data_.sum();
        double wd = Math.sqrt(this.data_.ssq());
        double tval = wm / wd;
        double vct = n > 200 ? 2.55 : (n > 80 ? 2.0 : 1.96);
        return Math.abs(tval) > vct;
    }

    private boolean isNstMean() {
        SarimaSpecification spec = this.spec_.clone();
        RegArimaEstimator monitor = new RegArimaEstimator(new SarimaMapping(spec, true));
        monitor.setPrecision(1.0E-4);
        RegArimaModel<SarimaModel> model = new RegArimaModel<SarimaModel>(new SarimaModel(spec), this.data_);
        model.setMeanCorrection(true);
        RegArimaEstimation<SarimaModel> est = monitor.process(model);
        if (est == null) {
            return false;
        }
        double t = est.likelihood.getTStats(false, 0)[0];
        int n = this.data_.getLength();
        double vct = n <= 80 ? 1.96 : (n <= 155 ? 1.98 : (n <= 230 ? 2.1 : (n <= 350 ? 2.3 : 2.5)));
        return Math.abs(t) > vct;
    }

    @Override
    public void setLimits(int maxd, int maxbd) {
        this.maxd = maxd;
        this.maxbd = maxbd;
    }
}

