/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.special.MixedAirlineModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.ssf.ICompositeModel;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ssf.implementation.SsfNoise;

class MixedAirlineCompositeModel
implements ICompositeModel {
    final SsfArima ssf;
    final SsfNoise noise;
    final int freq;
    final int[] np;
    final double h;

    public MixedAirlineCompositeModel(MixedAirlineModel model) {
        this.ssf = new SsfArima(model.getAirline());
        this.noise = new SsfNoise();
        this.h = Math.sqrt(model.getNoisyPeriodsVariance());
        this.freq = model.getFrequency();
        this.np = model.getNoisyPeriods();
    }

    public MixedAirlineCompositeModel(SarimaModel airline, double nweight, int[] np) {
        this.ssf = new SsfArima(airline);
        this.noise = new SsfNoise();
        this.h = nweight;
        this.np = np;
        this.freq = airline.getSpecification().getFrequency();
    }

    @Override
    public int getComponentsCount() {
        return 2;
    }

    @Override
    public ISsf getComponent(int iCmp) {
        return iCmp == 0 ? this.ssf : this.noise;
    }

    @Override
    public double getWeight(int iCmp, int pos) {
        if (iCmp == 0) {
            return 1.0;
        }
        int cpos = pos % this.freq;
        for (int i = 0; i < this.np.length; ++i) {
            if (this.np[i] != cpos) continue;
            return this.h;
        }
        return 0.0;
    }

    public double getNoiseWeight() {
        return this.h;
    }

    public SarimaModel getAirline() {
        return (SarimaModel)this.ssf.getModel();
    }

    public void setAirlineParameters(double th, double bth) {
    }

    @Override
    public boolean hasConstantWeights() {
        return false;
    }

    MixedAirlineModel toModel() {
        MixedAirlineModel model = new MixedAirlineModel();
        model.setFrequency(this.freq);
        model.setNoisyPeriods(this.np);
        model.setNoisyPeriodsVariance(this.h * this.h);
        SarimaModel airline = (SarimaModel)this.ssf.getModel();
        model.setTheta(airline.theta(1));
        model.setBTheta(airline.btheta(1));
        return model;
    }
}

