/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;

public class AutoRegressiveDistance {
    public static double compute(IArimaModel a, IArimaModel b, int npi) {
        RationalBackFilter pia = a.getPiWeights();
        RationalBackFilter pib = b.getPiWeights();
        double[] wa = pia.getWeights(npi + 1);
        double[] wb = pib.getWeights(npi + 1);
        double d = 0.0;
        for (int i = 1; i <= npi; ++i) {
            double di = wa[i] - wb[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }

    public static double compute2(IArimaModel a, IArimaModel b, int npi) {
        RationalBackFilter pia = a.getPiWeights();
        BackFilter na = pia.getNumerator();
        BackFilter da = pia.getDenominator();
        RationalBackFilter pib = b.getPiWeights();
        BackFilter nb = pib.getNumerator();
        BackFilter db = pib.getDenominator();
        BackFilter n = na.times(db).minus(nb.times(da));
        double[] c = n.getCoefficients();
        if (c.length == 1) {
            return 0.0;
        }
        double[] cc = new double[c.length - 1];
        System.arraycopy(c, 1, cc, 0, cc.length);
        n = BackFilter.of(cc);
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(true);
        if (smp.simplify(n, da)) {
            n = (BackFilter)smp.getLeft();
            da = (BackFilter)smp.getRight();
        }
        if (smp.simplify(n, db)) {
            n = (BackFilter)smp.getLeft();
            db = (BackFilter)smp.getRight();
        }
        RationalBackFilter dpi = new RationalBackFilter(n, da.times(db));
        double[] w = dpi.getWeights(npi);
        double d = 0.0;
        for (int i = 0; i < npi; ++i) {
            double di = w[i];
            d += di * di;
        }
        return Math.sqrt(d);
    }
}

